/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.mfw4j.utilities;

import java.util.ArrayList;

public class MFWCrnIDHelper {
    public static final char LEFT_BRACKET = '[';
    public static final char RIGHT_BRACKET = ']';
    public static final String RIGHT_BRACKET_ESCAPED = "]]";
    public static final char DOT = '.';

    public static String cleanIDEntry(String idEntry) {
        boolean lastCharWasASpace = false;
        String temp = idEntry.trim();
        StringBuilder cleanedEntry = new StringBuilder();
        for (int i = 0; i < temp.length(); ++i) {
            char c = temp.charAt(i);
            boolean bSpace = Character.isWhitespace(c);
            if (Character.isISOControl(c) || bSpace && lastCharWasASpace) continue;
            cleanedEntry.append(c);
            lastCharWasASpace = bSpace;
        }
        return cleanedEntry.toString();
    }

    public static void parseID(String anID, ArrayList<String> idEntries) {
        int beginPos = -1;
        int endPos = -1;
        boolean endFound = true;
        int idLen = anID.length();
        if (idLen < 2) {
            return;
        }
        if (anID.charAt(0) != '[' && anID.charAt(idLen - 1) != ']') {
            return;
        }
        for (int idx = 0; idx < idLen; ++idx) {
            char sChar = anID.charAt(idx);
            if (sChar == '[') {
                if (!endFound) continue;
                beginPos = idx + 1;
                endFound = false;
                continue;
            }
            if (sChar != ']') continue;
            if (idx < idLen - 1 && anID.charAt(idx + 1) == ']') {
                ++idx;
                continue;
            }
            endPos = idx;
            endFound = true;
            String temp = anID.substring(beginPos, endPos);
            idEntries.add(temp.replaceAll(RIGHT_BRACKET_ESCAPED, Character.toString(']')));
        }
    }

    public static String addEntryToID(String anID, String idEntry) {
        String sTemp = idEntry.replaceAll(Character.toString(']'), RIGHT_BRACKET_ESCAPED);
        StringBuilder newID = null;
        if (anID.length() == 0) {
            newID = new StringBuilder();
            newID.append('[');
        } else {
            newID = new StringBuilder(anID);
            newID.append('.');
            newID.append('[');
        }
        newID.append(sTemp);
        newID.append(']');
        return newID.toString();
    }

    public static boolean isMacro(String sValue) {
        if (sValue != null && sValue.contains("#")) {
            return (sValue = sValue.trim()).charAt(0) == '#' && sValue.charAt(sValue.length() - 1) == '#';
        }
        return false;
    }
}

