/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.mfw4j.utilities;

import com.cognos.developer.schemas.bibus._3.Account;
import com.cognos.developer.schemas.bibus._3.BiBusHeader;
import com.cognos.mfw4j.utilities.IMFWCMRequestExecutor;
import com.cognos.mfw4j.utilities.MFWBiBusHelper;
import com.cognos.mfw4j.utilities.MFWConfiguration;
import com.cognos.mfw4j.utilities.MFWContentHelper;
import com.cognos.mfw4j.utilities.MFWModelNotFoundException;
import com.cognos.mfw4j.utilities.MFWSimpleCMRequestExecutor;
import com.cognos.mfw4j.utilities.soap.AuthenticationCommand;
import com.cognos.mfw4j.utilities.soap.DispatcherContentManagerQueryCommand;
import com.cognos.mfw4j.utilities.soap.ObjectPropertiesCommand;
import com.cognos.mfw4j.utilities.soap.ReportQueryCommand;
import com.cognos.mfw4j.utilities.soap.RetreiveViewsCommand;
import com.cognos.mfw4j.utilities.soap.RetrieveAccountCommand;
import com.cognos.mfw4j.utilities.soap.RetrieveConnectionSignonCommand;
import com.cognos.mfw4j.utilities.soap.RetrieveDatasourceConnectionCommand;
import com.cognos.mfw4j.utilities.soap.UpdateMetadataCommand;
import com.cognos.mfw4j.utilities.soap.UserIdentityCommand;
import com.cognos.mfw4j.utilities.soap.UserNameCommand;
import com.cognos.pogo.bibus.CommandExecutionException;
import java.io.InputStream;
import java.rmi.RemoteException;
import java.util.List;
import java.util.concurrent.atomic.AtomicReference;
import org.dom4j.Element;

class MFWRCIHelper
extends MFWContentHelper {
    private static final boolean gUseAxisSDK4CMQueries = !"false".equals(MFWConfiguration.getInstance().getGeneralCapability("useSDK4CMQueries"));
    String m_contentLocale = null;
    String m_productLocale = null;
    IMFWCMRequestExecutor m_executor = null;
    DispatcherContentManagerQueryCommand m_cmQuery = null;

    MFWRCIHelper(String productLocale, String contentLocale) {
        this.m_productLocale = productLocale;
        this.m_contentLocale = contentLocale;
        this.m_executor = new MFWSimpleCMRequestExecutor(null, null);
    }

    MFWRCIHelper(String productLocale, String contentLocale, IMFWCMRequestExecutor executor) {
        this.m_productLocale = productLocale;
        this.m_contentLocale = contentLocale;
        this.m_executor = executor == null ? new MFWSimpleCMRequestExecutor(null, null) : executor;
    }

    private BiBusHeader getHeader() {
        return MFWBiBusHelper.buildBiBusHeaderFrom(this.m_executor.getEnvelope());
    }

    @Override
    public void destroy() {
        if (this.m_cmQuery != null) {
            this.m_cmQuery.releaseConnection();
            this.m_cmQuery = null;
        }
        this.m_executor = null;
    }

    @Override
    public String authenticateUser(String sNamespace, String sUserID, String sPassword) {
        AuthenticationCommand authCommand = new AuthenticationCommand(this.m_contentLocale, this.m_productLocale, sNamespace, sUserID, sPassword);
        authCommand.execute();
        String passport = authCommand.getPassport();
        this.m_executor.setPassport(passport);
        return passport;
    }

    @Override
    public void getUserIdentity(final List<String> vUserMemberships) {
        this.m_executor.execute(new Runnable(){

            @Override
            public void run() {
                UserIdentityCommand modCommand = new UserIdentityCommand(MFWRCIHelper.this.m_executor.getPassport(), MFWRCIHelper.this.m_contentLocale, MFWRCIHelper.this.m_productLocale, MFWRCIHelper.this.getHeader());
                modCommand.queryForMemberships(vUserMemberships);
            }
        });
    }

    @Override
    public String getUserName() {
        final AtomicReference result = new AtomicReference();
        this.m_executor.execute(new Runnable(){

            @Override
            public void run() {
                UserNameCommand nameCommand = new UserNameCommand(MFWRCIHelper.this.m_executor.getPassport(), MFWRCIHelper.this.m_contentLocale, MFWRCIHelper.this.m_productLocale, MFWRCIHelper.this.getHeader());
                result.set(nameCommand.queryForUserName());
            }
        });
        return (String)result.get();
    }

    @Override
    public Account getUserAccount() {
        final AtomicReference result = new AtomicReference();
        this.m_executor.execute(new Runnable(){

            @Override
            public void run() {
                RetrieveAccountCommand nameCommand = new RetrieveAccountCommand(MFWRCIHelper.this.m_executor.getPassport(), MFWRCIHelper.this.m_contentLocale, MFWRCIHelper.this.m_productLocale, MFWRCIHelper.this.getHeader());
                result.set(nameCommand.queryForAccount());
            }
        });
        return (Account)result.get();
    }

    @Override
    public void queryReport(final String sReportCmPath, final Element connDOM, final Element promptDOM, final StringBuffer sReportQuery, final StringBuffer promptResult) {
        this.m_executor.execute(new Runnable(){

            @Override
            public void run() {
                ReportQueryCommand queryCommand = new ReportQueryCommand(MFWRCIHelper.this.m_executor.getPassport(), MFWRCIHelper.this.m_contentLocale, MFWRCIHelper.this.m_productLocale, MFWRCIHelper.this.getHeader());
                queryCommand.queryForReport(sReportCmPath, connDOM, promptDOM, sReportQuery, promptResult);
            }
        });
    }

    @Override
    public InputStream queryPackage(final String sPackageCmPath, final boolean bTryWithUntrustedConnection) {
        final AtomicReference result = new AtomicReference();
        this.m_executor.execute(new Runnable(){

            @Override
            public void run() {
                MFWRCIHelper.this.m_cmQuery = null;
                MFWRCIHelper.this.m_cmQuery = new DispatcherContentManagerQueryCommand(sPackageCmPath, !bTryWithUntrustedConnection, true, MFWRCIHelper.this.m_executor.getPassport(), MFWRCIHelper.this.m_contentLocale, MFWRCIHelper.this.m_productLocale, MFWRCIHelper.this.m_executor.getEnvelope());
                MFWRCIHelper.this.m_cmQuery.addQueryPropertyName("model");
                try {
                    MFWRCIHelper.this.m_cmQuery.execute();
                }
                catch (CommandExecutionException e) {
                    if (MFWRCIHelper.this.m_cmQuery != null) {
                        MFWRCIHelper.this.m_cmQuery.releaseConnection();
                    }
                    if (bTryWithUntrustedConnection) {
                        MFWRCIHelper.this.m_cmQuery = new DispatcherContentManagerQueryCommand(sPackageCmPath, true, true, MFWRCIHelper.this.m_executor.getPassport(), MFWRCIHelper.this.m_contentLocale, MFWRCIHelper.this.m_productLocale, MFWRCIHelper.this.m_executor.getEnvelope());
                        MFWRCIHelper.this.m_cmQuery.addQueryPropertyName("model");
                        try {
                            MFWRCIHelper.this.m_cmQuery.execute();
                        }
                        catch (CommandExecutionException retryException) {
                            if (MFWContentHelper.isModelNotFoundException((Exception)((Object)retryException))) {
                                throw new MFWModelNotFoundException(sPackageCmPath);
                            }
                            throw new RuntimeException(retryException.getMessage(), retryException);
                        }
                    }
                    if (MFWContentHelper.isModelNotFoundException((Exception)((Object)e))) {
                        throw new MFWModelNotFoundException(sPackageCmPath);
                    }
                    throw new RuntimeException(e.getMessage(), e);
                }
                result.set(MFWRCIHelper.this.m_cmQuery.getModel());
            }
        });
        return (InputStream)result.get();
    }

    @Override
    public List<Object> getObjectProperties(String cmSearchPath, String[] queryProps) {
        return this.getObjectProperties(cmSearchPath, queryProps, false);
    }

    @Override
    public List<Object> getObjectProperties(final String cmSearchPath, final String[] queryProps, final boolean forceCMTrusted, final boolean metadataRequest) {
        final AtomicReference outList = new AtomicReference();
        this.m_executor.execute(new Runnable(){

            @Override
            public void run() {
                if (gUseAxisSDK4CMQueries && !forceCMTrusted && !metadataRequest) {
                    ObjectPropertiesCommand modCommand = new ObjectPropertiesCommand(MFWRCIHelper.this.m_executor.getPassport(), MFWRCIHelper.this.m_contentLocale, MFWRCIHelper.this.m_productLocale, MFWRCIHelper.this.getHeader());
                    outList.set(modCommand.queryObjectProperties(cmSearchPath, queryProps));
                } else {
                    DispatcherContentManagerQueryCommand qc = new DispatcherContentManagerQueryCommand(cmSearchPath, forceCMTrusted, false, MFWRCIHelper.this.m_executor.getPassport(), MFWRCIHelper.this.m_contentLocale, MFWRCIHelper.this.m_productLocale, MFWRCIHelper.this.m_executor.getEnvelope());
                    for (int idx = 0; idx < queryProps.length; ++idx) {
                        qc.addQueryPropertyName(queryProps[idx]);
                    }
                    try {
                        qc.execute();
                        outList.set(qc.getObjectProperties(cmSearchPath, queryProps));
                    }
                    catch (CommandExecutionException e) {
                        if (MFWContentHelper.isModelNotFoundException((Exception)((Object)e))) {
                            throw new MFWModelNotFoundException(cmSearchPath);
                        }
                        throw new RuntimeException(e.getMessage(), e);
                    }
                }
            }
        });
        return (List)outList.get();
    }

    @Override
    public List<Object> getObjectProperties(String cmSearchPath, String[] queryProps, boolean forceCMTrusted) {
        boolean metadataRequest = false;
        return this.getObjectProperties(cmSearchPath, queryProps, forceCMTrusted, metadataRequest);
    }

    @Override
    public void getViews(final String modelPath, final List<String> outViews) {
        this.m_executor.execute(new Runnable(){

            @Override
            public void run() {
                if (gUseAxisSDK4CMQueries) {
                    RetreiveViewsCommand viewsCommand = new RetreiveViewsCommand(MFWRCIHelper.this.m_executor.getPassport(), MFWRCIHelper.this.m_contentLocale, MFWRCIHelper.this.m_productLocale, MFWRCIHelper.this.getHeader());
                    viewsCommand.getViews(modelPath, outViews);
                } else {
                    StringBuilder viewPath = new StringBuilder(modelPath);
                    viewPath.append("/modelView[permission('execute')]");
                    DispatcherContentManagerQueryCommand qc = new DispatcherContentManagerQueryCommand(viewPath.toString(), false, false, MFWRCIHelper.this.m_executor.getPassport(), MFWRCIHelper.this.m_contentLocale, MFWRCIHelper.this.m_productLocale, MFWRCIHelper.this.m_executor.getEnvelope());
                    qc.addQueryPropertyName("defaultName");
                    try {
                        qc.execute();
                        qc.getModelViews(viewPath.toString(), outViews);
                    }
                    catch (CommandExecutionException e) {
                        throw new RuntimeException(e.getMessage(), e);
                    }
                }
            }
        });
    }

    @Override
    public String updateMetadata(String requestID, final String request) throws RemoteException {
        final AtomicReference result = new AtomicReference();
        try {
            this.m_executor.execute(new Runnable(){

                @Override
                public void run() {
                    try {
                        UpdateMetadataCommand ume = new UpdateMetadataCommand(MFWRCIHelper.this.m_executor.getPassport(), MFWRCIHelper.this.m_contentLocale, MFWRCIHelper.this.m_productLocale, MFWRCIHelper.this.getHeader());
                        result.set(ume.updateMetadata(request));
                    }
                    catch (RemoteException e) {
                        throw new RuntimeException(e);
                    }
                }
            });
        }
        catch (RuntimeException e) {
            Throwable cause = e.getCause();
            if (cause != null && cause instanceof RemoteException) {
                throw (RemoteException)cause;
            }
            throw e;
        }
        return (String)result.get();
    }

    @Override
    public MFWContentHelper.ConnectionRecord[] getDatasourceConnections(String cmDatasourceName) {
        StringBuffer strBuf = new StringBuffer("CAMID(\":\")/dataSource[@name=\"");
        strBuf.append(cmDatasourceName);
        strBuf.append("\"]/dataSourceConnection");
        final String cmDatasourcePath = strBuf.toString();
        final AtomicReference result = new AtomicReference();
        this.m_executor.execute(new Runnable(){

            @Override
            public void run() {
                RetrieveDatasourceConnectionCommand connCommand = new RetrieveDatasourceConnectionCommand(MFWRCIHelper.this.m_executor.getPassport(), MFWRCIHelper.this.m_contentLocale, MFWRCIHelper.this.m_productLocale, MFWRCIHelper.this.getHeader());
                result.set(connCommand.queryForConnection(cmDatasourcePath.toString()));
            }
        });
        return (MFWContentHelper.ConnectionRecord[])result.get();
    }

    @Override
    public MFWContentHelper.SignonRecord[] getConnectionSignons(String cmConnectionPath) {
        StringBuffer strBuf = new StringBuffer(cmConnectionPath);
        strBuf.append("/dataSourceSignon");
        final String signonQuery = strBuf.toString();
        final AtomicReference result = new AtomicReference();
        this.m_executor.execute(new Runnable(){

            @Override
            public void run() {
                RetrieveConnectionSignonCommand signonCommand = new RetrieveConnectionSignonCommand(MFWRCIHelper.this.m_executor.getPassport(), MFWRCIHelper.this.m_contentLocale, MFWRCIHelper.this.m_productLocale, MFWRCIHelper.this.getHeader());
                result.set(signonCommand.queryForSignon(signonQuery));
            }
        });
        return (MFWContentHelper.SignonRecord[])result.get();
    }

    public static void main(String[] args) {
        MFWRCIHelper rciHelper = new MFWRCIHelper("en", "en");
        String pass = rciHelper.authenticateUser("", "", "");
        System.out.println("Passport: " + pass);
    }
}

