/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.mfw4j.utilities;

import java.io.StringWriter;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.dom4j.DocumentException;
import org.dom4j.DocumentHelper;
import org.dom4j.Node;
import org.dom4j.xpath.DefaultXPath;
import org.jaxen.NamespaceContext;
import org.jaxen.SimpleNamespaceContext;
import org.w3c.dom.Element;

public class MFWXMLHelper {
    public static Node selectSingleNode(Node node, String xpath) {
        Pattern p = Pattern.compile("(document|evaluate)\\s*\\(");
        Matcher m = p.matcher(xpath);
        if (m.find()) {
            throw new RuntimeException("Invalid xpath to MFWXMLHelper.selectSingleNode detected");
        }
        SimpleNamespaceContext context = new SimpleNamespaceContext();
        context.addNamespace("bus", node.getDocument().getRootElement().getNamespaceURI());
        DefaultXPath path = new DefaultXPath(xpath);
        path.setNamespaceContext((NamespaceContext)context);
        Node n = path.selectSingleNode((Object)node);
        return n;
    }

    public static String w3cToString(org.w3c.dom.Node doc) {
        if (doc == null) {
            return "";
        }
        StringWriter domText = new StringWriter();
        StreamResult sr = new StreamResult(domText);
        Transformer t = null;
        try {
            t = TransformerFactory.newInstance().newTransformer();
            t.setOutputProperty("omit-xml-declaration", "yes");
            t.transform(new DOMSource(doc), sr);
        }
        catch (TransformerException tfe) {
            throw new RuntimeException(tfe.getMessage(), tfe);
        }
        return domText.toString();
    }

    public static org.dom4j.Element stringToDom4j(String xmlSource) {
        try {
            return DocumentHelper.parseText((String)xmlSource).getRootElement();
        }
        catch (DocumentException e) {
            throw new RuntimeException(e.getMessage(), e);
        }
    }

    public static org.dom4j.Element w3c2dom4j(Element element) {
        String elmStr = MFWXMLHelper.w3cToString(element);
        org.dom4j.Element dom4jElement = MFWXMLHelper.stringToDom4j(elmStr);
        return dom4jElement;
    }
}

