/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.mfw4j.utilities;

import com.cognos.accman.jcam.crypto.CAMCryptoException;
import com.cognos.accman.jcam.crypto.CAMFactory;
import com.cognos.accman.jcam.crypto.EncryptingSession;
import com.cognos.ccl4j.exceptions.CCLRuntimeException;
import java.io.Reader;
import java.io.StringReader;
import java.io.UnsupportedEncodingException;
import org.apache.axis.encoding.Base64;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;
import org.dom4j.io.SAXReader;

public class MFWXMLStringDecryptionHelper {
    private static final String ENCRYPTED_VALUE = "encryptedValue";
    static final String CAM_INIT_PARAM = "<initializeDocument><serviceID>MFW</serviceID></initializeDocument>";
    static final String EMPTY_STRING = "";
    private String mDecryptedCredentialAsXML = null;

    MFWXMLStringDecryptionHelper(String credentialXML) {
        this.extractAndDecryptCMCredentials(credentialXML);
    }

    private void extractAndDecryptCMCredentials(String credentialXML) {
        if (credentialXML == null) {
            return;
        }
        Document domCredential = null;
        try {
            SAXReader reader = new SAXReader();
            domCredential = reader.read((Reader)new StringReader(credentialXML));
        }
        catch (Throwable t) {
            return;
        }
        Element credentialsElement = domCredential.getRootElement();
        Element encryptedValueElement = credentialsElement.element(ENCRYPTED_VALUE);
        if (encryptedValueElement == null) {
            this.mDecryptedCredentialAsXML = credentialXML;
            return;
        }
        try {
            this.mDecryptedCredentialAsXML = this.decrypt(encryptedValueElement);
        }
        catch (Throwable e) {
            throw new CCLRuntimeException(e, e.getMessage());
        }
    }

    private String decrypt(Element encryptedCredential) {
        try {
            String base64EncryptedString = encryptedCredential.getText();
            if (base64EncryptedString == null) {
                return EMPTY_STRING;
            }
            byte[] decodedData = Base64.decode((String)base64EncryptedString);
            CAMFactory camFactory = new CAMFactory();
            camFactory.initialize(CAM_INIT_PARAM.getBytes("UTF-8"));
            EncryptingSession session = camFactory.createEncryptingSession();
            byte[] decryptedData = session.decryptData(decodedData);
            return new String(decryptedData, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new CCLRuntimeException((Throwable)e, e.getMessage());
        }
        catch (CAMCryptoException e) {
            throw new CCLRuntimeException((Throwable)e, e.getMessage());
        }
    }

    public String extractCredentialsFromXMLString(String paramItemName) {
        Document doc = null;
        String paramItemValue = EMPTY_STRING;
        try {
            doc = DocumentHelper.parseText((String)this.mDecryptedCredentialAsXML);
        }
        catch (DocumentException e) {
            throw new CCLRuntimeException((Throwable)e, e.getMessage());
        }
        if (doc == null) {
            return paramItemValue;
        }
        Element credentialsElement = doc.getRootElement();
        Element paramElement = credentialsElement.element(paramItemName);
        if (paramElement != null) {
            paramItemValue = paramElement.getText();
        }
        return paramItemValue;
    }
}

