/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.mfw4j.utilities;

import com.cognos.mfw4j.utilities.MFWException;
import com.cognos.mfw4j.utilities.MFWXMLDump;
import java.io.Reader;
import java.io.StringReader;
import java.util.List;
import org.apache.axis.AxisFault;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.DocumentHelper;
import org.dom4j.io.SAXReader;
import org.w3c.dom.Element;

public class QFException
extends MFWException {
    public static final long serialVersionUID = 1L;
    public static final String Ambiguous_Connection_Fault_Code = "CQE-801";
    public static final String Ambiguous_Connection_Fault_String = "Ambiguous connection";
    public static final String Ambiguous_Signon_Fault_Code = "CQE-802";
    public static final String Ambiguous_Signon_Fault_String = "Ambiguous signon";
    public static final String Connection_Not_Found_Code = "CQE-804";
    public static final String Connection_Not_Found_String = "Connection not found";
    public static final String Signon_Not_Found_Code = "CQE-805";
    public static final String Signon_Not_Found_String = "Signon not found";
    public static final int QFS_ERROR_START = -5000001;
    public static final int QFS_ERROR_INVALID_USERNAME = -5000042;
    public static final int QFS_ERROR_INVALID_PASSWORD = -5000043;
    public static final int QFS_ERROR_INVALID_CONNECTION_STRING = -5000044;
    public static final int QFS_ERROR_INVALID_SERVER = -5000045;
    public static final int QFS_ERROR_NO_CONNECT = -5000046;
    public static final int QFS_ERROR_INVALID_CUBE_PASSWORD = -5000048;
    public static final int QFS_ERROR_FAULT_AMBIGUOUS_CONNECTION = -5000049;
    public static final int QFS_ERROR_FAULT_AMBIGUOUS_SIGNON = -5000050;
    public static final int QFS_ERROR_FAULT_LOGON_FAILURE = -5000051;
    public static final int QFS_ERROR_FAULT_CONNECTION_NOT_FOUND = -5000053;
    public static final int QFS_ERROR_FAULT_SIGNON_NOT_FOUND = -5000054;
    public static final int QFS_ERROR_FAULT_DATABASE_NOT_FOUND = -5000055;
    private org.dom4j.Element mDOMDetail = null;

    public QFException(int errorCode) {
        super(errorCode);
    }

    public void setDOM(org.dom4j.Element elmDetail) {
        this.mDOMDetail = elmDetail;
    }

    public org.dom4j.Element getDOM() {
        return this.mDOMDetail;
    }

    public static org.dom4j.Element createFaultElement(String faultCode, String faultString) {
        Document document = DocumentHelper.createDocument();
        org.dom4j.Element fault = document.addElement("Fault");
        org.dom4j.Element faultCodeEl = fault.addElement("faultcode");
        faultCodeEl.setText(faultCode);
        org.dom4j.Element faultStringEl = fault.addElement("faultstring");
        faultStringEl.setText(faultString);
        return fault;
    }

    @Override
    public String getMessage() {
        org.dom4j.Element elem;
        if (this.mDOMDetail != null && (elem = (org.dom4j.Element)this.mDOMDetail.selectSingleNode("faultstring|*//faultstring")) != null) {
            String str = elem.getText();
            int firstSpace = str.indexOf(" ");
            return str.substring(0, firstSpace);
        }
        return super.getMessage();
    }

    public static void checkQF(AxisFault f) {
        String fc = f.getFaultCode().getLocalPart();
        Element[] fd = f.getFaultDetails();
        if (fd.length == 0) {
            return;
        }
        String faultDetail = MFWXMLDump.DumpElement(fd[0]);
        try {
            SAXReader reader = new SAXReader();
            Document resultsDoc = reader.read((Reader)new StringReader(faultDetail));
            if (!fc.startsWith("CQE")) {
                List msgs = resultsDoc.getRootElement().selectNodes("//messageString");
                StringBuilder outMsg = new StringBuilder(f.getMessage());
                for (int idx = 0; idx < msgs.size(); ++idx) {
                    outMsg.append("\n\t");
                    outMsg.append(((org.dom4j.Element)msgs.get(idx)).getText());
                }
                throw new RuntimeException(outMsg.toString(), (Throwable)f);
            }
            QFException.processQF(fc, f.getMessage(), resultsDoc);
        }
        catch (DocumentException de) {
            throw new RuntimeException(de.getMessage(), de);
        }
    }

    public static void processQF(String fc, String fs, Document soapEnvelope) {
        String code = fc.substring(4);
        org.dom4j.Element fault = (org.dom4j.Element)soapEnvelope.selectSingleNode("//*[local-name()='Fault']");
        org.dom4j.Element newFault = (org.dom4j.Element)fault.clone();
        newFault.detach();
        QFException qf = new QFException(Integer.parseInt(code));
        qf.setDOM(newFault);
        throw qf;
    }
}

