/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.mfw4j.utilities.soap;

import com.cognos.ccl4j.exceptions.CCLRuntimeException;
import com.cognos.cclcfgapi.CCLConfigurationException;
import com.cognos.developer.schemas.bibus._3.AsynchDetail;
import com.cognos.developer.schemas.bibus._3.AsynchDetailReportOutput;
import com.cognos.developer.schemas.bibus._3.AsynchDetailReportStatus;
import com.cognos.developer.schemas.bibus._3.AsynchDetailReportStatusEnum;
import com.cognos.developer.schemas.bibus._3.AsynchDetailUnstructuredData;
import com.cognos.developer.schemas.bibus._3.AsynchOptionEnum;
import com.cognos.developer.schemas.bibus._3.AsynchOptionInt;
import com.cognos.developer.schemas.bibus._3.AsynchReply;
import com.cognos.developer.schemas.bibus._3.AsynchReplyStatusEnum;
import com.cognos.developer.schemas.bibus._3.BiBusHeader;
import com.cognos.developer.schemas.bibus._3.Option;
import com.cognos.developer.schemas.bibus._3.ParameterValue;
import com.cognos.developer.schemas.bibus._3.ParmValueItem;
import com.cognos.developer.schemas.bibus._3.ReportServiceQueryOptionBoolean;
import com.cognos.developer.schemas.bibus._3.ReportServiceQueryOptionEnum;
import com.cognos.developer.schemas.bibus._3.ReportServiceQueryOptionSpecificationFormat;
import com.cognos.developer.schemas.bibus._3.ReportService_PortType;
import com.cognos.developer.schemas.bibus._3.RunOptionBoolean;
import com.cognos.developer.schemas.bibus._3.RunOptionEnum;
import com.cognos.developer.schemas.bibus._3.RunOptionString;
import com.cognos.developer.schemas.bibus._3.SearchPathSingleObject;
import com.cognos.developer.schemas.bibus._3.SimpleParmValueItem;
import com.cognos.developer.schemas.bibus._3.SpecificationFormatEnum;
import com.cognos.mfw4j.utilities.MFWException;
import com.cognos.mfw4j.utilities.soap.AxisSoapCommand;
import com.cognos.mfw4j.utilities.soap.prompt.MFWQsPromptFaultHelper;
import com.cognos.mfw4j.utilities.soap.prompt.MFWRCIParameterHelper;
import java.net.MalformedURLException;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.List;
import javax.xml.rpc.ServiceException;
import org.dom4j.Element;

public class ReportQueryCommand
extends AxisSoapCommand {
    public ReportQueryCommand(String passport, String contentLocale, String productLocale, BiBusHeader bibusHeader) {
        super(contentLocale, productLocale, passport, bibusHeader);
    }

    public void queryForReport(String sReportCmPath, Element connDOM, Element promptDom, StringBuffer sReportQuery, StringBuffer promptResult) {
        Option[] options = new Option[7];
        AsynchOptionInt opt1 = new AsynchOptionInt();
        opt1.setName(AsynchOptionEnum.primaryWaitThreshold);
        opt1.setValue(999);
        options[0] = opt1;
        AsynchOptionInt opt2 = new AsynchOptionInt();
        opt2.setName(AsynchOptionEnum.secondaryWaitThreshold);
        opt2.setValue(999);
        options[1] = opt2;
        ReportServiceQueryOptionSpecificationFormat pQSpecOpt = new ReportServiceQueryOptionSpecificationFormat();
        pQSpecOpt.setName(ReportServiceQueryOptionEnum.specificationFormat);
        pQSpecOpt.setValue(SpecificationFormatEnum.report);
        options[2] = pQSpecOpt;
        RunOptionString pRunOption = new RunOptionString();
        pRunOption.setName(RunOptionEnum.promptFormat);
        pRunOption.setValue("rawXML");
        options[3] = pRunOption;
        ReportServiceQueryOptionBoolean pQUpgrdOpt = new ReportServiceQueryOptionBoolean();
        pQUpgrdOpt.setName(ReportServiceQueryOptionEnum.upgrade);
        pQUpgrdOpt.setValue(true);
        options[4] = pQUpgrdOpt;
        ReportServiceQueryOptionBoolean querySetsOpt = new ReportServiceQueryOptionBoolean();
        querySetsOpt.setName(ReportServiceQueryOptionEnum.reportQuerySets);
        querySetsOpt.setValue(true);
        options[5] = querySetsOpt;
        RunOptionBoolean pPromptFaultOpt = new RunOptionBoolean();
        pPromptFaultOpt.setName(RunOptionEnum.promptFaultInformation);
        pPromptFaultOpt.setValue(true);
        options[6] = pPromptFaultOpt;
        Element connectionDOM = connDOM;
        ArrayList<ParameterValue> promptValues = new ArrayList<ParameterValue>();
        if (connectionDOM != null) {
            ArrayList<Element> elements = new ArrayList<Element>();
            List connections = connectionDOM.selectNodes("//connection");
            elements.add(connectionDOM);
            for (int i = 0; i < connections.size(); ++i) {
                elements.add((Element)connections.get(i));
            }
            ArrayList<String> dataSourceNames = new ArrayList<String>();
            ArrayList<String> credentials = new ArrayList<String>();
            for (int i = 0; i < elements.size(); ++i) {
                String dataSourceName = this.getSOAPRequestParamKeyFor((Element)elements.get(i));
                String credentialValue = this.getSOAPRequestParamValueFor((Element)elements.get(i));
                if (dataSourceName == null || "".equals(dataSourceName) || credentialValue == null || "".equals(credentialValue)) continue;
                dataSourceNames.add(dataSourceName);
                credentials.add(credentialValue);
            }
            List parameters = connectionDOM.selectNodes("//*[local-name()='parameters']");
            if (parameters.size() != 0) {
                Element parameter = (Element)parameters.get(0);
                MFWQsPromptFaultHelper promptFaultHelper = new MFWQsPromptFaultHelper();
                Element elem = parameter;
                promptFaultHelper.doTake(elem);
                MFWRCIParameterHelper rciParamHelper = new MFWRCIParameterHelper(promptFaultHelper);
                rciParamHelper.getRCIParameterValues(promptValues);
            }
            for (int i = 0; i < dataSourceNames.size(); ++i) {
                String strName = (String)dataSourceNames.get(i);
                String itemName = (String)credentials.get(i);
                SimpleParmValueItem parmValueItem1 = new SimpleParmValueItem();
                parmValueItem1.setUse(itemName);
                ParmValueItem[] parmValueItemArray = new ParmValueItem[]{parmValueItem1};
                ParameterValue parameterValue1 = new ParameterValue();
                parameterValue1.setName(strName);
                parameterValue1.setValue(parmValueItemArray);
                promptValues.add(parameterValue1);
            }
        }
        if (promptDom != null) {
            MFWQsPromptFaultHelper promptFaultHelper = new MFWQsPromptFaultHelper();
            promptFaultHelper.doTake(promptDom);
            MFWRCIParameterHelper rciParamHelper = new MFWRCIParameterHelper(promptFaultHelper);
            rciParamHelper.getRCIParameterValues(promptValues);
        }
        ParameterValue[] parameterValueArray = new ParameterValue[promptValues.size()];
        for (int i = 0; i < promptValues.size(); ++i) {
            ParameterValue value;
            parameterValueArray[i] = value = (ParameterValue)promptValues.get(i);
        }
        try {
            BiBusHeader header = this.buildSimpleHeader();
            ReportService_PortType port = this.getReportServicePort(header);
            SearchPathSingleObject so = new SearchPathSingleObject(sReportCmPath);
            AsynchReply pReply = port.query(so, parameterValueArray, options);
            MFWException.ASSERT(pReply != null, "Expecting a valid reply");
            AsynchReplyStatusEnum eReqStatus = pReply.getStatus();
            MFWException.ASSERT(eReqStatus == AsynchReplyStatusEnum.complete || eReqStatus == AsynchReplyStatusEnum.conversationComplete, "The reply must have a completed status");
            AsynchDetail[] pReplyDetails = pReply.getDetails();
            MFWException.ASSERT(pReplyDetails != null && pReplyDetails.length > 0, "Must have a valid detailed response entry");
            int reportOutputIndex = -1;
            int asyncDetailUnstructedDataIndex = -1;
            int asynchDetailReportStatusIndex = -1;
            for (int i = 0; i < pReplyDetails.length; ++i) {
                AsynchDetail detail = pReplyDetails[i];
                if (detail instanceof AsynchDetailReportOutput) {
                    reportOutputIndex = i;
                    continue;
                }
                if (detail instanceof AsynchDetailUnstructuredData) {
                    asyncDetailUnstructedDataIndex = i;
                    continue;
                }
                if (!(detail instanceof AsynchDetailReportStatus)) continue;
                asynchDetailReportStatusIndex = i;
            }
            if (reportOutputIndex != -1) {
                MFWException.ASSERT(asynchDetailReportStatusIndex != -1, "Expected status when receiving report output");
                AsynchDetailReportStatusEnum reportStatus = ((AsynchDetailReportStatus)pReplyDetails[asynchDetailReportStatusIndex]).getStatus();
                if (reportStatus == AsynchDetailReportStatusEnum.prompting) {
                    MFWException.ASSERT(asyncDetailUnstructedDataIndex != -1, "Expected unstructured data for prompt");
                    AsynchDetailUnstructuredData unstructured = (AsynchDetailUnstructuredData)pReplyDetails[asyncDetailUnstructedDataIndex];
                    MFWException.ASSERT(unstructured.getData() != null, "Expected xml data for prompt");
                    promptResult.append(unstructured.getData().get_value());
                } else {
                    MFWException.ASSERT(false, "Quering for report resulted in unhandled prompt");
                }
            } else if (asyncDetailUnstructedDataIndex != -1) {
                AsynchDetailUnstructuredData unstructured = (AsynchDetailUnstructuredData)pReplyDetails[asyncDetailUnstructedDataIndex];
                MFWException.ASSERT(unstructured.getData() != null, "Expected xml data");
                sReportQuery.append(unstructured.getData().get_value());
            } else {
                MFWException.ASSERT(false, "Failed to retrieve V5 for report");
            }
        }
        catch (ServiceException se) {
            throw new CCLRuntimeException((Throwable)se, se.getMessage());
        }
        catch (MalformedURLException mu) {
            throw new CCLRuntimeException((Throwable)mu, mu.getMessage());
        }
        catch (RemoteException re) {
            throw ReportQueryCommand.handleRemoteException(re);
        }
        catch (CCLConfigurationException ce) {
            throw new CCLRuntimeException((Throwable)ce, ce.getMessage());
        }
    }

    private String getSOAPRequestParamKeyFor(Element connection) {
        StringBuffer buf = new StringBuffer();
        buf.append("credential:");
        List dataSources = connection.selectNodes("dataSource | *//dataSource");
        if (dataSources.size() > 0) {
            String value = ((Element)dataSources.get(0)).attributeValue("value");
            if (value == null || "".equals(value)) {
                value = ((Element)dataSources.get(0)).getText();
            }
            if (value == null || "".equals(value)) {
                return null;
            }
            buf.append(value);
        }
        return buf.toString();
    }

    String getSOAPRequestParamValueFor(Element connection) {
        StringBuffer buf = new StringBuffer();
        buf.append("<credential><dataSourceConnection>");
        List children = connection.selectNodes("*");
        String searchPath = null;
        String cubePassword = null;
        String userName = null;
        String password = null;
        String signon = null;
        for (int i = 0; i < children.size(); ++i) {
            if (!(children.get(i) instanceof Element)) continue;
            Element elem = (Element)children.get(i);
            if ("searchPath".equals(elem.getName())) {
                searchPath = ((Element)children.get(i)).attributeValue("value");
                if (searchPath != null && !"".equals(searchPath)) continue;
                searchPath = elem.getText();
                continue;
            }
            if ("cubePassword".equals(elem.getName())) {
                cubePassword = elem.attributeValue("value");
                if (cubePassword != null && !"".equals(cubePassword)) continue;
                cubePassword = elem.getText();
                continue;
            }
            if ("signon".equals(elem.getName())) {
                Element searchPathElem;
                List searchPaths = elem.selectNodes("searchPath | *//searchPath");
                if (searchPaths.size() <= 0 || (signon = (searchPathElem = (Element)searchPaths.get(0)).attributeValue("value")) != null && !"".equals(signon)) continue;
                signon = searchPathElem.getText();
                continue;
            }
            if ("username".equals(elem.getName())) {
                userName = elem.attributeValue("value");
                if (userName != null && !"".equals(userName)) continue;
                userName = elem.getText();
                continue;
            }
            if (!"password".equals(elem.getName()) || (password = elem.attributeValue("value")) != null && !"".equals(password)) continue;
            password = elem.getText();
        }
        if (searchPath == null || "".equals(searchPath)) {
            return null;
        }
        buf.append(searchPath);
        buf.append("</dataSourceConnection>");
        if (cubePassword != null && !"".equals(cubePassword)) {
            buf.append("<cubePassword>");
            buf.append(cubePassword);
            buf.append("</cubePassword>");
        }
        if (userName != null && !"".equals(userName)) {
            buf.append("<username>");
            buf.append(userName);
            buf.append("</username>");
        }
        if (password != null && !"".equals(password)) {
            buf.append("<password>");
            buf.append(password);
            buf.append("</password>");
        }
        if (signon != null && !"".equals(signon)) {
            buf.append("<dataSourceSignon>");
            buf.append(signon);
            buf.append("</dataSourceSignon>");
        }
        buf.append("</credential>");
        return buf.toString();
    }
}

