/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.mfw4j.utilities.soap;

import com.cognos.ccl4j.exceptions.CCLRuntimeException;
import com.cognos.cclcfgapi.CCLConfigurationException;
import com.cognos.developer.schemas.bibus._3.BaseClass;
import com.cognos.developer.schemas.bibus._3.BiBusHeader;
import com.cognos.developer.schemas.bibus._3.ContentManagerService_PortType;
import com.cognos.developer.schemas.bibus._3.PropEnum;
import com.cognos.developer.schemas.bibus._3.SearchPathMultipleObject;
import com.cognos.developer.schemas.bibus._3.TokenProp;
import com.cognos.mfw4j.utilities.soap.AxisSoapCommand;
import java.net.MalformedURLException;
import java.rmi.RemoteException;
import java.util.List;
import javax.xml.rpc.ServiceException;

public class RetreiveViewsCommand
extends AxisSoapCommand {
    public RetreiveViewsCommand(String passport, String contentLocale, String productLocale, BiBusHeader bibusHeader) {
        super(contentLocale, productLocale, passport, bibusHeader);
    }

    public void getViews(String modelPath, List<String> views) {
        String modelViewPath = modelPath + "/modelView[permission('execute')]";
        try {
            BiBusHeader header = this.buildSimpleHeader();
            ContentManagerService_PortType port = this.getContentManagerServicePort(header);
            SearchPathMultipleObject smo = new SearchPathMultipleObject(modelViewPath);
            PropEnum[] props = new PropEnum[]{PropEnum.defaultName};
            BaseClass[] res = port.query(smo, props, null, null);
            for (int i = 0; i < res.length; ++i) {
                String val;
                BaseClass baseClass = res[i];
                TokenProp defName = baseClass.getDefaultName();
                if (defName == null || views.contains(val = defName.getValue())) continue;
                views.add(val);
            }
        }
        catch (ServiceException se) {
            throw new CCLRuntimeException((Throwable)se, se.getMessage());
        }
        catch (MalformedURLException mu) {
            throw new CCLRuntimeException((Throwable)mu, mu.getMessage());
        }
        catch (RemoteException re) {
            throw RetreiveViewsCommand.handleRemoteException(re);
        }
        catch (CCLConfigurationException ce) {
            throw new CCLRuntimeException((Throwable)ce, ce.getMessage());
        }
    }
}

