/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.mfw4j.utilities.soap;

import com.cognos.ccl4j.exceptions.CCLRuntimeException;
import com.cognos.cclcfgapi.CCLConfigurationException;
import com.cognos.developer.schemas.bibus._3.BaseClass;
import com.cognos.developer.schemas.bibus._3.BaseClassArrayProp;
import com.cognos.developer.schemas.bibus._3.BiBusHeader;
import com.cognos.developer.schemas.bibus._3.ContentManagerService_PortType;
import com.cognos.developer.schemas.bibus._3.DataSourceConnection;
import com.cognos.developer.schemas.bibus._3.Namespace;
import com.cognos.developer.schemas.bibus._3.PropEnum;
import com.cognos.developer.schemas.bibus._3.SearchPathMultipleObject;
import com.cognos.developer.schemas.bibus._3.StringProp;
import com.cognos.mfw4j.utilities.MFWContentHelper;
import com.cognos.mfw4j.utilities.soap.AxisSoapCommand;
import java.net.MalformedURLException;
import java.rmi.RemoteException;
import javax.xml.rpc.ServiceException;

public class RetrieveDatasourceConnectionCommand
extends AxisSoapCommand {
    public RetrieveDatasourceConnectionCommand(String passport, String contentLocale, String productLocale, BiBusHeader bibusHeader) {
        super(contentLocale, productLocale, passport, bibusHeader);
    }

    public MFWContentHelper.ConnectionRecord[] queryForConnection(String cmDatasourcePath) {
        MFWContentHelper.ConnectionRecord[] outConns = null;
        try {
            DataSourceConnection aConn;
            BiBusHeader header = this.buildSimpleHeader();
            ContentManagerService_PortType port = this.getContentManagerServicePort(header);
            SearchPathMultipleObject smo = new SearchPathMultipleObject(cmDatasourcePath);
            PropEnum[] props = new PropEnum[]{PropEnum.defaultName, PropEnum.searchPath, PropEnum.connectionString, PropEnum.credentialNamespaces};
            BaseClass[] results = port.query(smo, props, null, null);
            int outputSize = 0;
            for (int i = 0; i < results.length; ++i) {
                if (results[i] == null || !(results[i] instanceof DataSourceConnection) || (aConn = (DataSourceConnection)results[i]) == null || aConn.getConnectionString() == null && aConn.getDefaultName() == null && aConn.getSearchPath() == null) continue;
                ++outputSize;
            }
            if (outputSize == 0) {
                return null;
            }
            outConns = new MFWContentHelper.ConnectionRecord[outputSize];
            for (int idx = 0; idx < results.length; ++idx) {
                BaseClass[] values;
                if (results[idx] == null || !(results[idx] instanceof DataSourceConnection) || (aConn = (DataSourceConnection)results[idx]) == null || aConn.getConnectionString() == null && aConn.getDefaultName() == null && aConn.getSearchPath() == null) continue;
                String connName = aConn.getDefaultName() != null ? aConn.getDefaultName().getValue() : null;
                String connPath = aConn.getSearchPath() != null ? aConn.getSearchPath().getValue() : null;
                String connStr = aConn.getConnectionString() != null ? aConn.getConnectionString().getValue() : null;
                String credentialNamespace = null;
                BaseClassArrayProp credentialNamespaces = aConn.getCredentialNamespaces();
                if (credentialNamespaces != null && (values = credentialNamespaces.getValue()) != null && values.length > 0) {
                    Namespace ns = (Namespace)values[0];
                    StringProp prop = ns.getSearchPath();
                    credentialNamespace = prop.getValue();
                }
                outConns[idx] = new MFWContentHelper.ConnectionRecord(connName, connPath, connStr, credentialNamespace);
            }
        }
        catch (ServiceException se) {
            throw new CCLRuntimeException((Throwable)se, se.getMessage());
        }
        catch (MalformedURLException mu) {
            throw new CCLRuntimeException((Throwable)mu, mu.getMessage());
        }
        catch (RemoteException re) {
            throw RetrieveDatasourceConnectionCommand.handleRemoteException(re);
        }
        catch (CCLConfigurationException ce) {
            throw new CCLRuntimeException((Throwable)ce, ce.getMessage());
        }
        return outConns;
    }
}

