/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.mfw4j.utilities.soap;

import com.cognos.ccl4j.exceptions.CCLRuntimeException;
import com.cognos.cclcfgapi.CCLConfigurationException;
import com.cognos.developer.schemas.bibus._3.BaseClass;
import com.cognos.developer.schemas.bibus._3.BaseClassArrayProp;
import com.cognos.developer.schemas.bibus._3.BiBusHeader;
import com.cognos.developer.schemas.bibus._3.ContentManagerService_PortType;
import com.cognos.developer.schemas.bibus._3.PropEnum;
import com.cognos.developer.schemas.bibus._3.SearchPathMultipleObject;
import com.cognos.developer.schemas.bibus._3.Session;
import com.cognos.developer.schemas.bibus._3.StringProp;
import com.cognos.mfw4j.utilities.soap.AxisSoapCommand;
import java.net.MalformedURLException;
import java.rmi.RemoteException;
import java.util.List;
import javax.xml.rpc.ServiceException;

public class UserIdentityCommand
extends AxisSoapCommand {
    public UserIdentityCommand(String passport, String contentLocale, String productLocale, BiBusHeader bibusHeader) {
        super(contentLocale, productLocale, passport, bibusHeader);
    }

    public void queryForMemberships(List<String> memberships) {
        try {
            BiBusHeader header = this.buildSimpleHeader();
            ContentManagerService_PortType port = this.getContentManagerServicePort(header);
            SearchPathMultipleObject smo = new SearchPathMultipleObject("~~");
            PropEnum[] props = new PropEnum[]{PropEnum.identity};
            BaseClass[] res = port.query(smo, props, null, null);
            for (int i = 0; i < res.length; ++i) {
                BaseClass baseClass = res[i];
                if (!(baseClass instanceof Session)) continue;
                Session session = (Session)baseClass;
                BaseClassArrayProp identities = session.getIdentity();
                BaseClass[] values = identities.getValue();
                for (int j = 0; values != null && j < values.length; ++j) {
                    StringProp searchPath = values[j].getSearchPath();
                    if (searchPath == null) continue;
                    memberships.add(searchPath.getValue().intern());
                }
            }
        }
        catch (ServiceException se) {
            throw new CCLRuntimeException((Throwable)se, se.getMessage());
        }
        catch (MalformedURLException mu) {
            throw new CCLRuntimeException((Throwable)mu, mu.getMessage());
        }
        catch (RemoteException re) {
            throw UserIdentityCommand.handleRemoteException(re);
        }
        catch (CCLConfigurationException ce) {
            throw new CCLRuntimeException((Throwable)ce, ce.getMessage());
        }
    }
}

