/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.mfw4j.utilities.soap.prompt;

import com.cognos.developer.schemas.bibus._3.BoundRangeParmValueItem;
import com.cognos.developer.schemas.bibus._3.HierarchicalParmValueItem;
import com.cognos.developer.schemas.bibus._3.ParameterValue;
import com.cognos.developer.schemas.bibus._3.ParmValueItem;
import com.cognos.developer.schemas.bibus._3.SimpleParmValueItem;
import com.cognos.developer.schemas.bibus._3.UnboundedEndRangeParmValueItem;
import com.cognos.developer.schemas.bibus._3.UnboundedStartRangeParmValueItem;
import com.cognos.mfw4j.utilities.soap.prompt.MFWQsParamValueItemHelper;
import com.cognos.mfw4j.utilities.soap.prompt.MFWQsParamValueItemHierarchyHelper;
import com.cognos.mfw4j.utilities.soap.prompt.MFWQsParamValueItemRangeHelper;
import com.cognos.mfw4j.utilities.soap.prompt.MFWQsParamValueItemSimpleHelper;
import com.cognos.mfw4j.utilities.soap.prompt.MFWQsParameterHelper;
import com.cognos.mfw4j.utilities.soap.prompt.MFWQsPromptFaultHelper;
import java.util.List;

public final class MFWRCIParameterHelper {
    ParameterValue[] m_pRCIParameterValues;
    MFWQsPromptFaultHelper m_pDomParameterValues;
    short m_eState;
    public static final short EState_kBuildRCIParameters = 0;
    public static final short EState_kBuildDOMParameters = 1;
    public static final short EState_kAllBuilt = 2;

    public MFWRCIParameterHelper(MFWQsPromptFaultHelper domParameterValues) {
        this.m_pDomParameterValues = domParameterValues;
        this.m_pRCIParameterValues = null;
        this.m_eState = 0;
    }

    public void getRCIParameterValues(List<ParameterValue> paramterValues) {
        if (this.m_eState == 0) {
            List<MFWQsParameterHelper> domParametersList;
            if (this.m_pDomParameterValues != null && (domParametersList = this.m_pDomParameterValues.getParameters()) != null && domParametersList.size() > 0) {
                for (int i = 0; i < domParametersList.size(); ++i) {
                    MFWQsParameterHelper currentParameter = domParametersList.get(i);
                    ParameterValue pCurrentRCIParamValue = new ParameterValue();
                    paramterValues.add(pCurrentRCIParamValue);
                    pCurrentRCIParamValue.setName(currentParameter.getName());
                    List<MFWQsParamValueItemHelper> currentParameterItems = currentParameter.getValues();
                    if (currentParameterItems.size() == 0) continue;
                    int currentParamItemIdx = 0;
                    pCurrentRCIParamValue.setValue(new ParmValueItem[currentParameterItems.size()]);
                    for (int curPrmIdx = 0; curPrmIdx < currentParameterItems.size(); ++curPrmIdx) {
                        ParmValueItem pRCIValueItem;
                        MFWQsParamValueItemHelper currentItem = currentParameterItems.get(curPrmIdx);
                        pCurrentRCIParamValue.getValue()[currentParamItemIdx] = pRCIValueItem = this.buildRCIValueItem(currentItem);
                        ++currentParamItemIdx;
                    }
                }
            }
            this.m_eState = (short)2;
        }
    }

    private ParmValueItem buildRCIValueItem(MFWQsParamValueItemHelper domItem) {
        SimpleParmValueItem pValueItem = null;
        if (domItem instanceof MFWQsParamValueItemSimpleHelper) {
            pValueItem = this.buildRCIValueItemSimple((MFWQsParamValueItemSimpleHelper)domItem);
        } else if (domItem instanceof MFWQsParamValueItemHierarchyHelper) {
            pValueItem = this.buildRCIValueItemHierarchical((MFWQsParamValueItemHierarchyHelper)domItem);
        } else if (domItem instanceof MFWQsParamValueItemRangeHelper) {
            String type = domItem.getBiBusType();
            if ("bus:unboundedStartParmValueItem".equals(type)) {
                pValueItem = this.buildRCIValueItemUnboundedStartRange((MFWQsParamValueItemRangeHelper)domItem);
            } else if ("bus:unboundedEndParmValueItem".equals(type)) {
                pValueItem = this.buildRCIValueItemUnboundedEndRange((MFWQsParamValueItemRangeHelper)domItem);
            } else if ("bus:boundRangeParmValueItem".equals(type)) {
                pValueItem = this.buildRCIValueItemBoundedRange((MFWQsParamValueItemRangeHelper)domItem);
            }
        }
        if (pValueItem != null) {
            pValueItem.setInclusive(domItem.isInclusive());
        }
        return pValueItem;
    }

    public MFWQsPromptFaultHelper getDOMParameterValues() {
        if (this.m_eState == 1 && this.m_pRCIParameterValues != null && this.m_pRCIParameterValues.length > 0) {
            this.m_pDomParameterValues = new MFWQsPromptFaultHelper();
            for (int pRCIParameterValuesIdx = 0; pRCIParameterValuesIdx < this.m_pRCIParameterValues.length; ++pRCIParameterValuesIdx) {
                ParameterValue pCurrentRCIParameter = this.m_pRCIParameterValues[pRCIParameterValuesIdx];
                MFWQsParameterHelper pDOMParameter = this.m_pDomParameterValues.createParameter();
                String parameterName = pCurrentRCIParameter.getName();
                pDOMParameter.setName(parameterName);
                ParmValueItem[] pRCIParameterValueItems = pCurrentRCIParameter.getValue();
                if (pRCIParameterValueItems == null) continue;
                for (int pRCIParameterValueItemsIdx = 0; pRCIParameterValueItemsIdx < pRCIParameterValueItems.length; ++pRCIParameterValueItemsIdx) {
                    MFWQsParamValueItemHelper pDomItem;
                    ParmValueItem pCurrentParmValueItem = pRCIParameterValueItems[pRCIParameterValueItemsIdx];
                    if (pCurrentParmValueItem instanceof SimpleParmValueItem) {
                        pDomItem = this.buildDOMValueItemSimple((SimpleParmValueItem)pCurrentParmValueItem);
                        pDOMParameter.addValue(pDomItem);
                        continue;
                    }
                    if (pCurrentParmValueItem instanceof HierarchicalParmValueItem) {
                        pDomItem = this.buildDOMValueItemHierarchical((HierarchicalParmValueItem)pCurrentParmValueItem);
                        pDOMParameter.addValue(pDomItem);
                        continue;
                    }
                    if (pCurrentParmValueItem instanceof UnboundedStartRangeParmValueItem) {
                        pDomItem = this.buildDOMValueItemUnboundedStartRange((UnboundedStartRangeParmValueItem)pCurrentParmValueItem);
                        pDOMParameter.addValue(pDomItem);
                        continue;
                    }
                    if (pCurrentParmValueItem instanceof UnboundedEndRangeParmValueItem) {
                        pDomItem = this.buildDOMValueItemUnboundedEndRange((UnboundedEndRangeParmValueItem)pCurrentParmValueItem);
                        pDOMParameter.addValue(pDomItem);
                        continue;
                    }
                    if (!(pCurrentParmValueItem instanceof BoundRangeParmValueItem)) continue;
                    pDomItem = this.buildDOMValueItemBoundedRange((BoundRangeParmValueItem)pCurrentParmValueItem);
                    pDOMParameter.addValue(pDomItem);
                }
            }
        }
        this.m_eState = (short)2;
        return this.m_pDomParameterValues;
    }

    private SimpleParmValueItem buildRCIValueItemSimple(MFWQsParamValueItemSimpleHelper domItemSimple) {
        SimpleParmValueItem pValueItem = new SimpleParmValueItem();
        pValueItem.setDisplay(domItemSimple.getDisplay());
        pValueItem.setUse(domItemSimple.getUse());
        return pValueItem;
    }

    private MFWQsParamValueItemSimpleHelper buildDOMValueItemSimple(SimpleParmValueItem pRCIParmValueItemSimple) {
        MFWQsParamValueItemSimpleHelper pValueItem = new MFWQsParamValueItemSimpleHelper();
        String value = pRCIParmValueItemSimple.getDisplay();
        pValueItem.setDisplay(value);
        String value2 = pRCIParmValueItemSimple.getUse();
        pValueItem.setUse(value2);
        return pValueItem;
    }

    private HierarchicalParmValueItem buildRCIValueItemHierarchical(MFWQsParamValueItemHierarchyHelper domItemHierarchical) {
        HierarchicalParmValueItem pValueItem = new HierarchicalParmValueItem();
        MFWQsParamValueItemSimpleHelper pDOMValue = domItemHierarchical.getValue();
        pValueItem.setValue(this.buildRCIValueItemSimple(pDOMValue));
        List<MFWQsParamValueItemHierarchyHelper> subNodeHelpers = domItemHierarchical.getSubNodes();
        if (subNodeHelpers.size() > 0) {
            pValueItem.setSubNodes(new HierarchicalParmValueItem[subNodeHelpers.size()]);
            int subNodeIdx = 0;
            for (int subNdIdx = 0; subNdIdx < subNodeHelpers.size(); ++subNdIdx) {
                HierarchicalParmValueItem pRCISubNodeItem;
                MFWQsParamValueItemHierarchyHelper currentSubNodeHelper = subNodeHelpers.get(subNdIdx);
                pValueItem.getSubNodes()[subNodeIdx] = pRCISubNodeItem = this.buildRCIValueItemHierarchical(currentSubNodeHelper);
                ++subNodeIdx;
            }
        }
        return pValueItem;
    }

    private MFWQsParamValueItemHierarchyHelper buildDOMValueItemHierarchical(HierarchicalParmValueItem pRCIParmValueItemHierarchical) {
        MFWQsParamValueItemHierarchyHelper pValueItem = new MFWQsParamValueItemHierarchyHelper();
        pValueItem.setValue(this.buildDOMValueItemSimple(pRCIParmValueItemHierarchical.getValue()));
        if (pRCIParmValueItemHierarchical.getSubNodes() != null) {
            for (int subNodesIdx = 0; subNodesIdx < pRCIParmValueItemHierarchical.getSubNodes().length; ++subNodesIdx) {
                HierarchicalParmValueItem pRCISubNodeItem = pRCIParmValueItemHierarchical.getSubNodes()[subNodesIdx];
                pValueItem.addSubNode();
                this.buildDOMValueItemHierarchical(pRCISubNodeItem);
            }
        }
        return pValueItem;
    }

    UnboundedStartRangeParmValueItem buildRCIValueItemUnboundedStartRange(MFWQsParamValueItemRangeHelper domItemRange) {
        UnboundedStartRangeParmValueItem pValueItem = new UnboundedStartRangeParmValueItem();
        MFWQsParamValueItemSimpleHelper pDOMEndValue = domItemRange.getEnd();
        pValueItem.setEnd(this.buildRCIValueItemSimple(pDOMEndValue));
        return pValueItem;
    }

    private MFWQsParamValueItemRangeHelper buildDOMValueItemUnboundedStartRange(UnboundedStartRangeParmValueItem pRCIParmValueItemRange) {
        MFWQsParamValueItemRangeHelper pValueItem = new MFWQsParamValueItemRangeHelper();
        pValueItem.setEnd(this.buildDOMValueItemSimple(pRCIParmValueItemRange.getEnd()));
        return pValueItem;
    }

    private UnboundedEndRangeParmValueItem buildRCIValueItemUnboundedEndRange(MFWQsParamValueItemRangeHelper domItemRange) {
        UnboundedEndRangeParmValueItem pValueItem = new UnboundedEndRangeParmValueItem();
        MFWQsParamValueItemSimpleHelper pDOMStartValue = domItemRange.getStart();
        pValueItem.setStart(this.buildRCIValueItemSimple(pDOMStartValue));
        return pValueItem;
    }

    MFWQsParamValueItemRangeHelper buildDOMValueItemUnboundedEndRange(UnboundedEndRangeParmValueItem pRCIParmValueItemRange) {
        MFWQsParamValueItemRangeHelper pValueItem = new MFWQsParamValueItemRangeHelper();
        pValueItem.setStart(this.buildDOMValueItemSimple(pRCIParmValueItemRange.getStart()));
        return pValueItem;
    }

    BoundRangeParmValueItem buildRCIValueItemBoundedRange(MFWQsParamValueItemRangeHelper domItemRange) {
        BoundRangeParmValueItem pValueItem = new BoundRangeParmValueItem();
        MFWQsParamValueItemSimpleHelper pDOMStartValue = domItemRange.getStart();
        MFWQsParamValueItemSimpleHelper pDOMEndValue = domItemRange.getEnd();
        pValueItem.setStart(this.buildRCIValueItemSimple(pDOMStartValue));
        pValueItem.setEnd(this.buildRCIValueItemSimple(pDOMEndValue));
        return pValueItem;
    }

    MFWQsParamValueItemRangeHelper buildDOMValueItemBoundedRange(BoundRangeParmValueItem pRCIParmValueItemRange) {
        MFWQsParamValueItemRangeHelper pValueItem = new MFWQsParamValueItemRangeHelper();
        pValueItem.setStart(this.buildDOMValueItemSimple(pRCIParmValueItemRange.getStart()));
        pValueItem.setEnd(this.buildDOMValueItemSimple(pRCIParmValueItemRange.getEnd()));
        return pValueItem;
    }
}

