/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.pogo.zipi.handler;

import com.cognos.pogo.monitoring.jmx.ProxyServerCreator;
import com.cognos.pogo.monitoring.jmx.ProxyType;
import com.cognos.pogo.monitoring.jmx.remote.proxy.chooser.CheckProxyHandler;
import com.cognos.pogo.monitoring.jmx.remote.proxy.chooser.EventSubscriber;
import com.cognos.pogo.pdk.BasicHandler;
import com.cognos.pogo.pdk.Configuration;
import com.cognos.pogo.pdk.MessageContext;
import com.cognos.pogo.pdk.PogoEngine;
import com.cognos.pogo.pdk.PogoException;
import com.cognos.pogo.pdk.performance.PerformanceIndicator;
import com.cognos.pogo.pdk.performance.listener.PerformanceEventListener;
import com.cognos.pogo.transport.PogoServlet;
import com.cognos.pogo.util.PogoLogger;
import com.ibm.cognos.pogo.zipi.ZipiConfig;
import com.ibm.cognos.pogo.zipi.ZipiFactory;
import com.ibm.cognos.pogo.zipi.impl.ZeroImpactPerformanceIndicator;
import com.ibm.cognos.pogo.zipi.impl.ZipiCollector;
import com.ibm.cognos.pogo.zipi.impl.ZipiResponseFilter;

public class ZipiHandler
extends BasicHandler
implements EventSubscriber {
    private static final PogoLogger log = PogoLogger.getLogger();
    private ZipiCollector zipiCollector;
    private final ZipiResponseFilter responseFilter;

    public ZipiHandler() {
        this(null, new ZipiResponseFilter());
    }

    ZipiHandler(ZipiCollector zipiCollector, ZipiResponseFilter responseFilter) {
        super(log.getNativeLogger());
        this.zipiCollector = zipiCollector;
        this.responseFilter = responseFilter;
    }

    public void compose_impl(PogoEngine engine) throws PogoException {
        super.compose_impl(engine);
        this.subscribeToProxyServerNotifications(engine);
    }

    private void subscribeToProxyServerNotifications(PogoEngine engine) {
        CheckProxyHandler handler = (CheckProxyHandler)engine.lookupHandler("metricproxysetup.CheckProxyHandler");
        if (handler != null) {
            handler.registerForNotifications((EventSubscriber)this);
        }
    }

    public void invokeImpl(MessageContext mc) throws PogoException {
        this.responseFilter.handleResponse(mc);
    }

    public void configure(Configuration configuration) {
        this.reconfigure(configuration);
    }

    public void reconfigure(Configuration configuration) {
        this.zipiCollector = this.getZipiCollector(this.zipiCollector);
        this.updateConfiguration(configuration);
        this.updatePerformanceIndicatorRegistration();
        if (this.zipiCollector != null) {
            this.zipiCollector.reconfigure();
        }
    }

    private synchronized void updateConfiguration(Configuration config) {
        try {
            ZipiFactory.getConfig().reconfigure(config);
        }
        catch (Exception e) {
            log.warn("Exception while attempting to update the Zipi configuration: ", (Throwable)e);
        }
    }

    private void updatePerformanceIndicatorRegistration() {
        if (ZipiFactory.getConfig().isZipiEnabled()) {
            PerformanceIndicator.registerListener((PerformanceEventListener)new ZeroImpactPerformanceIndicator());
        } else {
            PerformanceIndicator.reset();
        }
    }

    public void proxyServerStarted(ProxyServerCreator proxyServerCreator) {
        log.debug(new Object[]{"proxyServrStarted"});
        if (this.isActiveJmxProxy(proxyServerCreator)) {
            this.zipiCollector = this.getZipiCollector(this.zipiCollector);
            if (this.zipiCollector != null) {
                this.zipiCollector.start(proxyServerCreator.getDispatchers());
            } else {
                ZipiConfig config = ZipiFactory.getConfig();
                config.setJMXDispatchers(proxyServerCreator.getDispatchers());
            }
        }
    }

    private ZipiCollector getZipiCollector(ZipiCollector prevZipiCollector) {
        PogoEngine pogoEngine = null;
        try {
            pogoEngine = PogoServlet.getPogoEngineStatic();
        }
        catch (Exception e) {
            log.debug(new Object[]{"pogo engine is not ready yet, wait"});
        }
        if (pogoEngine == null) {
            return prevZipiCollector;
        }
        ZipiCollector newZipiCollector = prevZipiCollector;
        if (pogoEngine.getReadyToProcess() || ZipiFactory.getConfig().isInTestMode()) {
            if (ZipiFactory.getConfig().isIPAEnabled()) {
                if (prevZipiCollector != null) {
                    prevZipiCollector.stop();
                }
                newZipiCollector = new ZipiCollector();
                newZipiCollector.start();
            } else if (prevZipiCollector == null && ZipiFactory.getConfig().isZipiEnabled()) {
                newZipiCollector = new ZipiCollector();
                newZipiCollector.start();
            }
        }
        return newZipiCollector;
    }

    private boolean isActiveJmxProxy(ProxyServerCreator proxyServerCreator) {
        ProxyType proxyType = proxyServerCreator.getType();
        log.debug(new Object[]{"proxyType is ", proxyType});
        return proxyType == ProxyType.ACTIVE;
    }

    public void proxyServerStopped(ProxyServerCreator proxyServerCreator) {
        log.debug(new Object[]{"proxyServerStopped"});
        if (this.isActiveJmxProxy(proxyServerCreator) && this.zipiCollector != null) {
            this.zipiCollector.stop();
        }
    }

    public void allServicesStarted() {
        super.allServicesStarted();
        ZipiFactory.initialize();
    }
}

