/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.pogo.zipi.impl;

import com.cognos.pogo.monitoring.jmx.JMXDispatcher;
import com.cognos.pogo.util.PogoLogger;
import com.cognos.pogo.util.threads.SafeThread;
import com.ibm.cognos.pogo.zipi.impl.ZipiClient;
import com.ibm.cognos.pogo.zipi.impl.ZipiStorage;
import java.util.Collection;

public class CollectorThread
extends SafeThread {
    private static final PogoLogger log = PogoLogger.getLogger();
    private final ZipiClient zipiClient;
    private final Collection<JMXDispatcher> jmxDispatchers;

    public CollectorThread(ZipiClient zipiClient, Collection<JMXDispatcher> jmxDispatchers) {
        super(CollectorThread.getThreadName());
        this.zipiClient = zipiClient;
        this.jmxDispatchers = jmxDispatchers;
    }

    public static String getThreadName() {
        return CollectorThread.class.getSimpleName();
    }

    protected void safeRun() {
        log.debug(new Object[]{"Collection started"});
        ZipiStorage.setCurrentService("zipiService");
        this.zipiClient.collectAllEvents(this.jmxDispatchers);
        log.debug(new Object[]{"Collection finished"});
    }

    public void stopCollection() {
        log.debug(new Object[]{"Stopping collection"});
        this.zipiClient.interruptCollection();
    }
}

