/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.pogo.zipi.impl;

import com.ibm.cognos.pogo.zipi.ZipiDatabaseConfiguration;
import java.sql.Connection;
import java.sql.Driver;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.util.Properties;

public class ConnectionFactory {
    public Connection createSqlConnection(ZipiDatabaseConfiguration config) throws SQLException {
        String url = config.getUrl();
        Properties credentials = config.getCredentials();
        if (credentials.size() > 0) {
            Connection connection = null;
            Driver driver = DriverManager.getDriver(url);
            if (driver != null && driver.acceptsURL(url)) {
                connection = driver.connect(url, credentials);
            } else {
                try {
                    connection = DriverManager.getConnection(url, credentials);
                }
                catch (Exception e) {
                    String username = (String)credentials.get("user");
                    if (username == null || username.isEmpty()) {
                        username = (String)credentials.get("username");
                    }
                    String password = (String)credentials.get("password");
                    connection = DriverManager.getConnection(url, username, password);
                }
            }
            return connection;
        }
        return DriverManager.getConnection(url);
    }
}

