/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.pogo.zipi.impl;

import com.cognos.pogo.monitoring.jmx.PogoMBeanServer;
import com.cognos.pogo.util.PogoLogger;
import com.ibm.cognos.pogo.zipi.Storage;
import com.ibm.cognos.pogo.zipi.ZipiAPI;
import com.ibm.cognos.pogo.zipi.ZipiFactory;
import com.ibm.cognos.pogo.zipi.ZipiTimer;
import com.ibm.cognos.pogo.zipi.impl.ZipiMBean;
import com.ibm.cognos.pogo.zipi.impl.ZipiMBeanEvents;
import java.util.ArrayList;
import java.util.Collection;
import javax.management.MBeanServer;
import javax.management.ObjectName;

public class Zipi
implements ZipiMBean {
    public static final String ZIPI_OBJECT_NAME = "com.cognos:type=ZIPI";
    public static final String ZIPI_SERVICE = "zipiService";
    private static final PogoLogger log = PogoLogger.getLogger();

    public void initialize() {
        try {
            ObjectName objectName = new ObjectName(ZIPI_OBJECT_NAME);
            log.debug(new Object[]{"Registering MBean: ", objectName});
            this.getMBeanServer().registerMBean(this, objectName);
        }
        catch (Exception e) {
            log.warn("Unable to register ZIPI MBean", (Throwable)e);
        }
    }

    private MBeanServer getMBeanServer() {
        return PogoMBeanServer.getInstance().getServer();
    }

    @Override
    public String[] getAllZipiIds() {
        log.debug(new Object[]{"getAllZipiIds"});
        return this.getZipiStorage().getAllZipiIds();
    }

    private Storage getZipiStorage() {
        return ZipiFactory.getStorage();
    }

    @Override
    public ZipiMBeanEvents getEventsFor(String id) {
        ZipiMBeanEvents events = this.getZipiStorage().getEventsFor(id);
        log.debug(new Object[]{"getEventsFor: ", id, " = ", events});
        return events;
    }

    @Override
    public Collection<ZipiMBeanEvents> dumpAllEvents() {
        String[] zids = this.getAllZipiIds();
        ArrayList<ZipiMBeanEvents> events = new ArrayList<ZipiMBeanEvents>(zids.length);
        for (String zid : zids) {
            events.add(this.getEventsFor(zid));
        }
        return events;
    }

    @Override
    public Collection<ZipiMBeanEvents> removeAllEvents() {
        return this.getZipiStorage().drainEvents();
    }

    @Override
    public void clearAllEvents() {
        this.getZipiStorage().clearAll();
    }

    @Override
    public long getCurrentTime() {
        return this.getZipiStorage().getCurrentTimeInNanos();
    }

    @Override
    public void updateEvents(Collection<ZipiMBeanEvents> events) {
        ZipiTimer timer = ZipiAPI.startOuterTimer("ZIPI.UpdateEvents");
        timer.setTargetService(ZIPI_SERVICE);
        try {
            this.getZipiStorage().updateEvents(events);
        }
        catch (RuntimeException ex) {
            log.warn("Exception", (Throwable)ex);
            throw ex;
        }
        finally {
            timer.stopAndClear();
        }
    }

    @Override
    public int getCurrentNumberOfEvents() {
        return this.getZipiStorage().getCurrentNumberOfEvents();
    }

    @Override
    public int getLastCollectionsIntervalInSecs() {
        return this.getZipiStorage().getLastIntervalBetweenCollectionsInSecs();
    }

    @Override
    public int getDiscardThresholdInMillis() {
        return ZipiFactory.getConfig().getDiscardThresholdInMillis();
    }
}

