/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.pogo.zipi.impl;

import com.ibm.cognos.pogo.zipi.ZipiFactory;
import com.ibm.cognos.pogo.zipi.ZipiTimer;
import com.ibm.cognos.pogo.zipi.impl.ZipiStorage;
import java.util.Hashtable;
import org.apache.axis.AxisFault;
import org.apache.axis.MessageContext;
import org.apache.axis.handlers.BasicHandler;

public class ZipiAxisRequestHandler
extends BasicHandler {
    private static final long serialVersionUID = 1L;

    public void invoke(MessageContext mc) throws AxisFault {
        ZipiTimer currentTimer = ZipiFactory.startConnectionTimer();
        if (currentTimer.isActive()) {
            this.updateZipi(mc, currentTimer);
        }
    }

    private void updateZipi(MessageContext mc, ZipiTimer timer) {
        Hashtable<String, String> requestHeaders = this.getRequestHeaders(mc);
        this.addZipiToRequestHeaders(timer, requestHeaders);
        this.updateMessageContext(mc, requestHeaders);
    }

    private Hashtable<String, String> getRequestHeaders(MessageContext mc) {
        Hashtable headers = (Hashtable)mc.getProperty("HTTP-Request-Headers");
        return headers != null ? headers : new Hashtable();
    }

    private void addZipiToRequestHeaders(ZipiTimer currentTimer, Hashtable<String, String> headers) {
        if (currentTimer.getZipiID().shouldLog()) {
            this.addHeader(headers, "zipi.id", currentTimer.getZipiID().toString());
            this.addHeader(headers, "zipi.src", ZipiStorage.getSrcURI());
            this.addHeader(headers, "zipi.src_svc", ZipiStorage.getCurrentService());
            this.addHeader(headers, "zipi.step", currentTimer.incrementAndGetCurrentStep());
        }
    }

    private void addHeader(Hashtable<String, String> headers, String name, String value) {
        if (value != null) {
            headers.put(name, value);
        }
    }

    private void updateMessageContext(MessageContext mc, Hashtable<String, String> headers) {
        mc.setProperty("HTTP-Request-Headers", headers);
    }
}

