/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.pogo.zipi.impl;

import com.cognos.pogo.monitoring.jmx.JMXDispatcher;
import com.cognos.pogo.pdk.PogoEngine;
import com.cognos.pogo.transport.PogoServlet;
import com.cognos.pogo.util.PogoLogger;
import com.cognos.pogo.util.timer.PogoTimer;
import com.cognos.pogo.util.timer.PogoTimerOwner;
import com.ibm.cognos.pogo.zipi.ZipiAPI;
import com.ibm.cognos.pogo.zipi.ZipiFactory;
import com.ibm.cognos.pogo.zipi.ZipiTimer;
import com.ibm.cognos.pogo.zipi.impl.ZipiDatabase;
import com.ibm.cognos.pogo.zipi.impl.ZipiStats;
import com.ibm.cognos.pogo.zipi.impl.collector.Activities;
import com.ibm.cognos.pogo.zipi.impl.collector.CollectedMBean;
import com.ibm.cognos.pogo.zipi.impl.collector.MBeanCollectorThread;
import com.ibm.cognos.pogo.zipi.impl.collector.Servers;
import com.ibm.cognos.pogo.zipi.impl.collector.ThreadFactoryImpl;
import java.sql.SQLException;
import java.util.Collection;
import java.util.LinkedList;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;

public class ZipiClient
implements PogoTimerOwner {
    private static final long DEFAULT_TIMEOUT_IN_MILLIS = 60000L;
    private static final PogoLogger staticLog = PogoLogger.getLogger();
    private final PogoLogger log;
    private final ZipiStats stats = new ZipiStats("Total (including DB connection)");
    private final ZipiDatabase zipiDB;
    private final Activities activities;
    private Servers servers;
    private boolean isInterrupted;
    private boolean isCollecting;
    private long interruptionTimeout = 60000L;
    private static final LinkedList<CollectedMBean> queue = new LinkedList();
    private final ExecutorService threadPool = Executors.newCachedThreadPool(new ThreadFactoryImpl("MBeanCollector:"));
    private int threadsToWaitFor;

    public ZipiClient() {
        this(new ZipiDatabase());
    }

    ZipiClient(ZipiDatabase zipiDB) {
        this(zipiDB, staticLog, new Activities(zipiDB));
    }

    ZipiClient(ZipiDatabase zipiDB, PogoLogger log, Activities activities) {
        this(zipiDB, log, activities, null);
    }

    ZipiClient(ZipiDatabase zipiDB, PogoLogger log, Activities activities, Servers servers) {
        this.zipiDB = zipiDB;
        this.log = log;
        this.activities = activities;
        this.servers = servers;
    }

    public void collectAllEvents(Collection<JMXDispatcher> jmxDispatchers) {
        this.isCollecting = true;
        try {
            if (!this.isInterrupted()) {
                this.tryToCollectAllEvents(jmxDispatchers);
            }
        }
        finally {
            this.isCollecting = false;
            this.clearInterrupt();
        }
    }

    protected void tryToCollectAllEvents(Collection<JMXDispatcher> jmxDispatchers) {
        ZipiTimer timer = ZipiAPI.startTimer("ZIPI.Collection");
        try {
            this.resetStats();
            this.checkDatabaseConnection();
            this.collectEvents(jmxDispatchers);
            this.logStats();
        }
        finally {
            timer.stop();
        }
    }

    private void resetStats() {
        this.zipiDB.resetSqlCount();
    }

    private void checkDatabaseConnection() {
        this.zipiDB.checkConnection();
    }

    private void collectEvents(Collection<JMXDispatcher> jmxDispatchers) {
        this.prepareBatch();
        this.resetThreadsToWaitFor();
        for (JMXDispatcher jmxDispatcher : jmxDispatchers) {
            if (this.isInterrupted()) continue;
            this.tryToCollectEventsFrom(jmxDispatcher);
        }
        this.writeEventsToDatabase();
        this.flushEvents();
    }

    private void resetThreadsToWaitFor() {
        this.threadsToWaitFor = 0;
    }

    private void prepareBatch() {
        try {
            this.getServers().prepareBatch();
        }
        catch (SQLException e) {
            this.log.warn("Failed to prepareBatch", (Throwable)e);
        }
    }

    private void flushEvents() {
        ZipiTimer timer = ZipiAPI.startTimer("ZIPI.FlushEvents");
        try {
            this.getServers().flush();
        }
        catch (SQLException e) {
            this.log.warn("Failed to flush events", (Throwable)e);
        }
        finally {
            timer.stop();
        }
    }

    private Servers getServers() {
        if (this.servers == null) {
            this.servers = new Servers(this.zipiDB, this.stats, this.activities);
        }
        return this.servers;
    }

    private void tryToCollectEventsFrom(JMXDispatcher jmxDispatcher) {
        if (jmxDispatcher.isConnected()) {
            this.collectEventsFrom(jmxDispatcher);
        } else {
            this.log.debug(new Object[]{"Can't collect events from (disconnected): ", jmxDispatcher.getJmxUrl()});
        }
    }

    private void collectEventsFrom(JMXDispatcher jmxDispatcher) {
        ++this.threadsToWaitFor;
        MBeanCollectorThread collectorThread = new MBeanCollectorThread(jmxDispatcher, queue);
        this.threadPool.execute(collectorThread);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeEventsToDatabase() {
        for (int count = 0; count != this.threadsToWaitFor; ++count) {
            CollectedMBean mbean = null;
            LinkedList<CollectedMBean> linkedList = queue;
            synchronized (linkedList) {
                while (queue.isEmpty()) {
                    try {
                        this.log.debug(new Object[]{"Queue empty waiting"});
                        queue.wait();
                    }
                    catch (InterruptedException interruptedException) {}
                }
                mbean = queue.removeFirst();
            }
            if (!mbean.isCollected()) continue;
            this.writeCollectedMBeanToDatabase(mbean);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeCollectedMBeanToDatabase(CollectedMBean mbean) {
        ZipiTimer timer = ZipiAPI.startTimer("ZIPI.WriteEventsToDatabase", mbean.getServerName());
        try {
            this.log.debug(new Object[]{"Writing events to database for: ", mbean.getServerName()});
            this.getServers().execute(mbean);
        }
        catch (Exception e) {
            this.log.warn("Failed to write events to database", (Throwable)e);
        }
        finally {
            timer.stop();
        }
    }

    private void connectToDatabase() {
        ZipiTimer timer = ZipiAPI.startTimer("ZIPI.DatabaseConnect");
        timer.setTargetService("zipiService");
        try {
            this.zipiDB.connectToDb();
        }
        catch (Exception e) {
            this.log.warn("Failed to connect to ZIPI database", (Throwable)e);
        }
        finally {
            timer.stop();
        }
    }

    private void disconnectFromDatabase() {
        ZipiTimer timer = ZipiAPI.startTimer("ZIPI.DatabaseDisconnect");
        timer.setTargetService("zipiService");
        try {
            this.zipiDB.disconnectFromDb();
        }
        catch (Exception e) {
            this.log.warn("Failed to disconnect from ZIPI database", (Throwable)e);
        }
        finally {
            timer.stop();
        }
    }

    public void initialize() {
        this.log.debug(new Object[]{"initialize"});
        this.clearInterrupt();
        this.initializeDatabase();
        this.connectToDatabase();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void initializeDatabase() {
        PogoEngine pogoEngine = null;
        try {
            pogoEngine = PogoServlet.getPogoEngineStatic();
        }
        catch (Exception e) {
            this.log.debug(new Object[]{"pogo engine is not ready yet, wait"});
        }
        if (pogoEngine == null) {
            return;
        }
        if (pogoEngine.getReadyToProcess() || ZipiFactory.getConfig().isInTestMode()) {
            ZipiTimer timer = ZipiAPI.startOuterTimer("ZIPI.Initialization");
            timer.setTargetService("zipiService");
            try {
                this.log.debug(new Object[]{"zipiDB.initialize"});
                this.zipiDB.initialize();
            }
            catch (Exception e) {
                this.log.warn("Failed to initialize ZIPI database", (Throwable)e);
            }
            finally {
                timer.stopAndClear();
            }
        }
    }

    private void logStats() {
        this.stats.collectionEnded();
        this.log.info(new Object[]{"Collection stats: ", this.zipiDB.getSqlCount(), " SQL commands"});
        this.stats.writeToLog();
        this.getServers().logStats();
    }

    public int getEventCount() {
        return this.stats.getEventCount();
    }

    public int getSqlCount() {
        return this.zipiDB.getSqlCount();
    }

    boolean hasServerCache() {
        return this.servers != null;
    }

    public void interruptCollection() {
        this.log.debug(new Object[]{"interruptCollection"});
        this.isInterrupted = true;
        this.getServers().interruptCollection();
        if (this.isCollecting) {
            this.waitForCurrentCollectionToComplete();
        }
    }

    protected void waitForCurrentCollectionToComplete() {
        this.log.debug(new Object[]{"Waiting for current collection to complete"});
        PogoTimer timer = new PogoTimer((PogoTimerOwner)this, null, this.interruptionTimeout);
        while (this.isCollecting) {
            this.sleep();
        }
        timer.cancel();
    }

    public void handleTimeoutEvent(Object parameter) throws Exception {
        this.log.warn(new Object[]{"Timed out waiting for collection to stop. Continuing."});
        this.isCollecting = false;
    }

    protected void sleep() {
        try {
            Thread.sleep(100L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    boolean isInterrupted() {
        return this.isInterrupted;
    }

    protected void clearInterrupt() {
        this.isInterrupted = false;
    }

    public void shutdown() {
        this.disconnectFromDatabase();
    }

    public void reconfigure() {
        this.zipiDB.reconfigure();
    }

    void setInteruptionTimeout(long interruptionTimeout) {
        this.interruptionTimeout = interruptionTimeout;
    }
}

