/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.pogo.zipi.impl;

import com.cognos.pogo.monitoring.jmx.JMXDispatcher;
import com.cognos.pogo.util.PogoLogger;
import com.cognos.pogo.util.timer.PogoTimer;
import com.cognos.pogo.util.timer.PogoTimerOwner;
import com.ibm.cognos.pogo.zipi.ZipiConfig;
import com.ibm.cognos.pogo.zipi.ZipiFactory;
import com.ibm.cognos.pogo.zipi.impl.CollectorThread;
import com.ibm.cognos.pogo.zipi.impl.TimerFactory;
import com.ibm.cognos.pogo.zipi.impl.ZipiClient;
import com.ibm.cognos.pogo.zipi.impl.ZipiWallTime;
import com.ibm.cognos.pogo.zipi.impl.collector.cleaner.ZipiCollectorCleaner;
import java.util.Collection;

public class ZipiCollector
implements PogoTimerOwner {
    public static final String HessianproxyStatus = "hessianproxy is not started yet";
    private static final PogoLogger log = PogoLogger.getLogger();
    private Collection<JMXDispatcher> jmxDispatchers;
    private final ZipiClient zipiClient;
    private PogoTimer collectorTimer;
    private final ZipiConfig zipiConfig;
    private long currentCollectionIntervalInMillis;
    private TimerFactory timerFactory;
    private CollectorThread collectorThread;
    private ZipiCollectorCleaner cleaner;

    public ZipiCollector() {
        this(new ZipiClient(), ZipiFactory.getConfig(), new TimerFactory());
    }

    ZipiCollector(ZipiClient zipiClient, ZipiConfig zipiConfig, TimerFactory timerFactory) {
        this.zipiClient = zipiClient;
        this.zipiConfig = zipiConfig;
        this.timerFactory = timerFactory;
    }

    public void start(Collection<JMXDispatcher> jmxDispatchers) {
        log.debug(new Object[]{"start collector, ", this.zipiConfig});
        if (this.isHessianProxyNull(jmxDispatchers)) {
            return;
        }
        this.jmxDispatchers = jmxDispatchers;
        this.stop();
        this.initializeZipiClient();
        this.startTimer();
        if (this.zipiConfig.isIPAEnabled()) {
            this.cleaner = new ZipiCollectorCleaner();
            this.cleaner.start();
        }
    }

    private void startTimer() {
        log.info(new Object[]{"Starting collector"});
        this.zipiConfig.decreaseDiscardThreshold();
        this.currentCollectionIntervalInMillis = this.getCollectionIntervalInMillis();
        this.collectorTimer = this.timerFactory.createPeriodicTimer(this, this.currentCollectionIntervalInMillis);
    }

    private long getCollectionIntervalInMillis() {
        return ZipiWallTime.secsToMillis(this.zipiConfig.getCollectionIntervalInSeconds());
    }

    public void stop() {
        log.debug(new Object[]{"stop"});
        if (this.isCollectorTimerRunning()) {
            this.stopCollector();
        }
        if (this.zipiConfig.isIPAEnabled() && this.cleaner != null) {
            this.cleaner.stop();
        }
    }

    public boolean isCollectorTimerRunning() {
        return this.collectorTimer != null;
    }

    private void stopCollector() {
        log.info(new Object[]{"Stopping collector"});
        this.stopCollectionTimer();
        this.stopCollectionThread();
        this.shutdownZipiClient();
    }

    protected void stopCollectionTimer() {
        this.collectorTimer.cancel();
        this.collectorTimer = null;
    }

    protected void stopCollectionThread() {
        if (this.collectorThread != null) {
            this.collectorThread.stopCollection();
        }
    }

    public void handleTimeoutEvent(Object parameter) throws Exception {
        log.debug(new Object[]{"Received timer notification to start collection"});
        if (this.zipiConfig.isZipiEnabledForCollection()) {
            this.collectAllEvents();
        }
    }

    protected void collectAllEvents() {
        if (this.isCollectorThreadRunning()) {
            log.debug(new Object[]{"Previous collection is still running. Ignoring."});
        } else {
            this.startNewCollectionThread();
        }
    }

    public boolean isCollectorThreadRunning() {
        return this.collectorThread != null && this.collectorThread.isAlive();
    }

    private void startNewCollectionThread() {
        log.debug(new Object[]{"Starting new collection thread"});
        if (this.jmxDispatchers == null) {
            ZipiConfig config = ZipiFactory.getConfig();
            this.jmxDispatchers = config.getJMXDispatchers();
            if (this.isHessianProxyNull(this.jmxDispatchers)) {
                return;
            }
        }
        this.collectorThread = new CollectorThread(this.zipiClient, this.jmxDispatchers);
        this.collectorThread.start();
    }

    public Thread.State getThreadState() {
        return this.collectorThread != null ? this.collectorThread.getState() : null;
    }

    public void reconfigure() {
        if (this.isCollectorTimerRunning() && this.hasChangedConfiguration()) {
            this.restartTimer();
        }
        this.zipiClient.reconfigure();
        if (this.zipiConfig.isZipiEnabled() && this.zipiConfig.isZipiEnabledForCollection()) {
            this.zipiClient.initialize();
        }
        if (this.zipiConfig.isIPAEnabled()) {
            if (this.cleaner == null) {
                this.cleaner = new ZipiCollectorCleaner();
                this.cleaner.start();
            }
            this.cleaner.reconfigure();
        }
    }

    private void initializeZipiClient() {
        if (this.zipiConfig.isZipiEnabled()) {
            this.zipiClient.initialize();
        }
    }

    private void shutdownZipiClient() {
        if (this.zipiConfig.isZipiEnabled()) {
            this.zipiClient.shutdown();
        }
    }

    private boolean hasChangedConfiguration() {
        return this.getCollectionIntervalInMillis() != this.currentCollectionIntervalInMillis;
    }

    private void restartTimer() {
        log.debug(new Object[]{"Restarting collector"});
        this.stopCollector();
        this.startTimer();
    }

    public void start() {
        ZipiConfig config = ZipiFactory.getConfig();
        Collection<JMXDispatcher> jmxDispatchers = config.getJMXDispatchers();
        this.start(jmxDispatchers);
    }

    private boolean isHessianProxyNull(Collection<JMXDispatcher> jmxDispatchers) {
        if (jmxDispatchers == null) {
            log.debug(new Object[]{HessianproxyStatus});
            return true;
        }
        return false;
    }
}

