/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.pogo.zipi.impl;

import com.cognos.pogo.util.PogoLogger;
import com.ibm.cognos.pogo.zipi.ZipiConfig;
import com.ibm.cognos.pogo.zipi.ZipiDatabaseConfiguration;
import com.ibm.cognos.pogo.zipi.ZipiFactory;
import com.ibm.cognos.pogo.zipi.ZipiTimer;
import com.ibm.cognos.pogo.zipi.impl.DatabaseConnection;
import com.ibm.cognos.pogo.zipi.impl.NullZipiDatabaseTables;
import com.ibm.cognos.pogo.zipi.impl.ZipiDatabaseTables;
import com.ibm.cognos.pogo.zipi.impl.collector.LookupSQLBuilder;
import com.ibm.cognos.pogo.zipi.impl.collector.SQLSelectBuilder;
import com.ibm.cognos.pogo.zipi.impl.collector.impl.SQLSelectMaxBuilderImpl;
import com.ibm.cognos.pogo.zipi.impl.tables.ZipiTable;
import java.sql.BatchUpdateException;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.log.Priority;

public class ZipiDatabase {
    public static final long NOT_FOUND = -1L;
    private static final PogoLogger staticLog = PogoLogger.getLogger();
    private static final String FOUND_MULTIPLE = "Should only ever find one row.  Found multiple rows of: ";
    private static final String FOLLOWING_SQL = " for the following sql: ";
    private static final String SQL_FAILED = " failed  for the following sql: ";
    private static final String SELECT_FAILED = "Select failed  for the following sql: ";
    private static final String USING_VALUE = " Using following value: ";
    private static final int DEFAULT_NUMBER_OF_HOURS_IN_TIME_TABLE = 24;
    private static final int DEFAULT_NUMBER_OF_YEARS_IN_DATE_TABLE = 20;
    private final PogoLogger log;
    private ZipiDatabaseTables dbTables;
    private ZipiConfig config;
    private DatabaseConnection databaseConnection;
    private int sqlCount;

    public ZipiDatabase() {
        this(staticLog);
    }

    public ZipiDatabase(PogoLogger log) {
        this(ZipiFactory.getConfig(), log, new DatabaseConnection());
    }

    public ZipiDatabase(ZipiConfig config) {
        this(config, staticLog, new DatabaseConnection());
    }

    public ZipiDatabase(ZipiConfig config, PogoLogger log, DatabaseConnection databaseConnection) {
        this.config = config;
        this.log = log;
        this.databaseConnection = databaseConnection;
        this.dbTables = new NullZipiDatabaseTables();
    }

    void reset() {
        this.databaseConnection = new DatabaseConnection();
        this.dbTables = new NullZipiDatabaseTables();
    }

    protected ZipiDatabaseConfiguration getConfig() {
        return this.config.getDatabaseConfig();
    }

    public void connectToDb() throws SQLException, ClassNotFoundException {
        this.dbTables = new ZipiDatabaseTables(this.getConfig());
        if (this.dbTables.isConfigured()) {
            this.databaseConnection.connect(this.getConfig());
        }
    }

    boolean hasAllDatabaseTables() throws SQLException {
        return this.isConnectedToDb() && this.hasDatabaseTables(this.dbTables.getAllTableNames());
    }

    boolean hasDatabaseTable(String tableName) throws SQLException {
        return this.isConnectedToDb() && this.hasDatabaseTables(this.toList(tableName));
    }

    public List<String> toList(String tableName) {
        ArrayList<String> tables = new ArrayList<String>();
        tables.add(tableName);
        return tables;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean hasDatabaseTables(List<String> tableNames) throws SQLException {
        Statement statement = this.createStatement();
        try {
            boolean bl = this.retrieveTableNames(statement) && this.allTablesFound(statement, tableNames);
            return bl;
        }
        finally {
            statement.close();
        }
    }

    public Statement createStatement(int resultSetType, int resultSetConcurrency) throws SQLException {
        return this.getDatabaseConnection().createStatement(resultSetType, resultSetConcurrency);
    }

    private boolean retrieveTableNames(Statement statement) {
        return this.tryToExecuteStatement(statement, this.dbTables.getSqlForListingTables());
    }

    private boolean tryToExecuteStatement(Statement statement, String sqlStatement) {
        try {
            return this.executeSQL(statement, sqlStatement);
        }
        catch (SQLException ex) {
            this.log.warn("Error running " + sqlStatement, (Throwable)ex);
            return false;
        }
    }

    private boolean executeSQL(Statement statement, String sqlStatement) throws SQLException {
        this.log.debug(new Object[]{"SQL: ", sqlStatement});
        try {
            boolean bl = statement.execute(sqlStatement);
            return bl;
        }
        catch (SQLException ex) {
            throw this.handleException(sqlStatement, ex);
        }
        finally {
            this.commitTransactions();
        }
    }

    private SQLException handleException(String sqlStatement, SQLException ex) {
        this.log.warn("Error running " + sqlStatement, (Throwable)ex);
        for (SQLException nested = ex.getNextException(); nested != null; nested = nested.getNextException()) {
            this.log.warn("Nested exception: ", (Throwable)nested);
        }
        return ex;
    }

    private boolean allTablesFound(Statement statement, List<String> tableNames) throws SQLException {
        Set<String> dbTables = this.getResult(statement);
        boolean allTablesFound = dbTables.containsAll(tableNames);
        this.log.debug(new Object[]{allTablesFound ? "Found" : "Did not find", " all the tables in the database:  ", dbTables});
        return allTablesFound;
    }

    private Set<String> getResult(Statement statement) throws SQLException {
        HashSet<String> resultValues = new HashSet<String>();
        ResultSet resultSet = statement.getResultSet();
        if (resultSet != null) {
            while (resultSet.next()) {
                resultValues.add(resultSet.getString(1));
            }
        }
        return resultValues;
    }

    public void dropDatabaseTables() throws SQLException {
        Statement statement = this.createStatement();
        try {
            this.dropDatabaseTables(statement);
        }
        finally {
            statement.close();
        }
    }

    private void dropDatabaseTables(Statement statement) throws SQLException {
        for (String[] dropTable : this.dbTables.getSqlForDroppingAllTables()) {
            this.addBatchSQL(statement, dropTable);
        }
        this.executeBatchSQL(statement);
    }

    private void createEmptyDatabaseTables() throws SQLException {
        Statement statement = this.createStatement();
        try {
            this.createEmptyDatabaseTables(statement);
        }
        finally {
            statement.close();
        }
    }

    public Statement createStatement() throws SQLException {
        return this.getDatabaseConnection().createStatement();
    }

    private void createEmptyDatabaseTables(Statement statement) throws SQLException {
        for (String[] createTable : this.dbTables.getSqlForCreatingAllTables()) {
            this.addBatchSQL(statement, createTable);
        }
        this.executeBatchSQL(statement);
    }

    private void addBatchSQL(Statement statement, String[] sqlCommands) throws SQLException {
        for (String sqlCommand : sqlCommands) {
            this.addBatchSQL(statement, sqlCommand);
        }
    }

    private void addBatchSQL(Statement statement, String sqlCommand) throws SQLException {
        this.log.debug(new Object[]{"SQL: (batch) ", sqlCommand});
        statement.addBatch(sqlCommand);
    }

    private void createDatabaseTables(int hours, int years) throws SQLException {
        this.log.debug(new Object[]{"createDatabaseTables"});
        this.createEmptyDatabaseTables();
        this.dbTables.populateDatabaseTables(this, hours, years);
    }

    public void executeBatchSQL_NoCommit(PreparedStatement statement) throws SQLException {
        this.log.debug(new Object[]{"Executing SQL Batch with PreparedStatement No Commit"});
        this.executeBatchStatement(statement, false);
    }

    public void executeBatchSQL(Statement statement) throws SQLException {
        this.log.debug(new Object[]{"Executing SQL Batch with Statement"});
        this.executeBatchStatement(statement, true);
        ++this.sqlCount;
    }

    private void executeBatchStatement(Statement statement, boolean commit) throws SQLException {
        try {
            statement.executeBatch();
        }
        catch (BatchUpdateException ex) {
            int[] updateCounts = ex.getUpdateCounts();
            StringBuilder batchException = new StringBuilder();
            batchException.append("Batch statement exception at index: ");
            for (int i = 0; i < updateCounts.length; ++i) {
                if (updateCounts[i] == 1) continue;
                batchException.append(i + 1);
                batchException.append(" ");
            }
            this.log.warn(new Object[]{batchException.toString()});
            throw this.handleException("BatchUpdateException during batch execution", ex);
        }
        catch (SQLException ex) {
            throw this.handleException("SQLException during batch execution", ex);
        }
        finally {
            if (commit) {
                this.commitTransactions();
            }
            statement.clearBatch();
        }
    }

    public PreparedStatement prepareStatement(String sql) throws SQLException {
        return this.getDatabaseConnection().prepareStatement(sql);
    }

    protected DatabaseConnection getDatabaseConnection() {
        return this.databaseConnection;
    }

    public void disconnectFromDb() throws SQLException {
        if (this.isConnectedToDb()) {
            this.closeDatabaseConnection();
        }
    }

    public boolean isConnectedToDb() {
        return this.getDatabaseConnection().isConnected();
    }

    private void closeDatabaseConnection() throws SQLException {
        try {
            this.commitTransactions();
        }
        finally {
            this.getDatabaseConnection().closeConnection();
        }
    }

    public void commitTransactions() throws SQLException {
        this.getDatabaseConnection().commitTransactions();
    }

    List<String> getAllTableNamesForTesting() {
        return this.dbTables.getAllTableNames();
    }

    public static void setLogPriority(Priority priority) {
        staticLog.setPriority(priority);
    }

    public long getNextID(String tableName, String columnId) {
        return this.dbTables.isConfigured() ? this.dbTables.getNextID(tableName, columnId) : 0L;
    }

    public long getNextID(String tableName) {
        return this.dbTables.isConfigured() ? this.dbTables.getNextID(tableName) : 0L;
    }

    public ZipiTable getZipiTable(String tableName) {
        return this.dbTables.isConfigured() ? this.dbTables.getZipiTable(tableName) : null;
    }

    public void initialize() throws SQLException, ClassNotFoundException {
        this.connectToDb();
        try {
            this.initTables(24, 20);
        }
        finally {
            this.disconnectFromDb();
        }
    }

    protected void initTables(int hours, int years) throws SQLException {
        if (this.hasAllDatabaseTables()) {
            this.dbTables.initializeNextIDs(this);
        } else {
            this.createDatabaseTables(hours, years);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getMaxValue(String table, String column) throws SQLException {
        SQLSelectMaxBuilderImpl sql = new SQLSelectMaxBuilderImpl(table, column, this);
        try {
            long l = this.queryDB(sql);
            return l;
        }
        finally {
            sql.closeStatement();
        }
    }

    public long lookup(LookupSQLBuilder lsb) throws SQLException {
        return this.queryDB(lsb.getSQLSelectBuilder());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private long queryDB(SQLSelectBuilder sb) throws SQLException {
        ZipiTimer timer = ZipiFactory.startTimer("ZIPI.queryDB");
        timer.setTargetService("zipiService");
        timer.setObjectPath(sb.getString());
        try {
            ResultSet resultSet = this.executeQuery(sb);
            long l = this.getResult(resultSet, sb);
            return l;
        }
        finally {
            timer.stop();
        }
    }

    private long getResult(ResultSet resultSet, SQLSelectBuilder sb) throws SQLException {
        try {
            long l = this.getID(resultSet, sb);
            return l;
        }
        catch (SQLException ex) {
            this.log.warn("Exception caught while trying to retrieve an id from a result set: ", (Throwable)ex);
            throw ex;
        }
        finally {
            this.closeResultSet(resultSet);
        }
    }

    private void closeResultSet(ResultSet resultSet) {
        try {
            if (resultSet != null) {
                resultSet.close();
            }
            this.commitTransactions();
        }
        catch (SQLException ex) {
            this.log.debug("Exception caught while trying to close a result set: ", (Throwable)ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private long getID(ResultSet resultSet, SQLSelectBuilder sql) throws SQLException {
        long returnValue = -1L;
        try {
            if (this.hasResult(resultSet)) {
                returnValue = resultSet.getLong(1);
                if (resultSet.wasNull()) {
                    returnValue = -1L;
                }
            }
        }
        finally {
            this.logWarningIfResultSetHasMultipleRows(resultSet, sql);
        }
        return returnValue;
    }

    public boolean hasResult(ResultSet resultSet) throws SQLException {
        return resultSet != null && !resultSet.isClosed() && resultSet.next();
    }

    private void logWarningIfResultSetHasMultipleRows(ResultSet resultSet, SQLSelectBuilder sql) throws SQLException {
        try {
            if (this.hasResult(resultSet)) {
                this.log.warn(new Object[]{FOUND_MULTIPLE, sql.getValue(), FOLLOWING_SQL, sql.getString()});
            }
        }
        catch (SQLException ex) {
            this.log.debug("Exception caught while trying to validate if result set has multiple rows: ", (Throwable)ex);
        }
    }

    private ResultSet executeQuery(SQLSelectBuilder sb) throws SQLException {
        try {
            PreparedStatement ps = sb.getPreparedStatement();
            return ps.executeQuery();
        }
        catch (SQLException e) {
            this.log.warn(new Object[]{SELECT_FAILED, sb.getString(), USING_VALUE, sb.getValue()});
            throw e;
        }
    }

    public int getSqlCount() {
        return this.sqlCount;
    }

    public void resetSqlCount() {
        this.sqlCount = 0;
    }

    public long getIndexFromLookupTable(LookupSQLBuilder lsb) throws SQLException {
        return this.isValid(lsb) ? this.getOrInsertIntoLookupTable(lsb) : -1L;
    }

    private long getOrInsertIntoLookupTable(LookupSQLBuilder lsb) throws SQLException {
        long id = this.lookup(lsb);
        return id == -1L ? this.insertIntoLookupTable(lsb) : id;
    }

    public long insertIntoLookupTable(LookupSQLBuilder lsb) throws SQLException {
        long nextID = this.getNextID(lsb.getTable());
        lsb.addBatch(nextID);
        return nextID;
    }

    private boolean isValid(LookupSQLBuilder lsb) {
        return this.isConnectedToDb() && lsb != null && lsb.isValid();
    }

    public void checkConnection() {
        this.databaseConnection.checkConnection();
    }

    public void reconfigure() {
        this.databaseConnection.reconfigure(this.getConfig());
    }
}

