/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.pogo.zipi.impl;

import com.cognos.pogo.bibus.CommandExecutionException;
import com.cognos.pogo.contentmanager.ContentManagerQueryCommand;
import com.cognos.pogo.util.CAMUtils;
import com.cognos.pogo.util.PogoLogger;
import com.ibm.cognos.pogo.zipi.ZipiFactory;
import com.ibm.cognos.pogo.zipi.impl.ZipiMBeanConfig;
import com.ibm.cognos.pogo.zipi.impl.ZipiUtils;
import java.util.HashMap;
import java.util.Properties;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;
import org.dom4j.Node;

public class ZipiDatabaseCMConfiguration {
    private static final HashMap<String, String> JDBCConnectString = new HashMap<String, String>(){
        private static final long serialVersionUID = 20170910L;
        {
            this.put("MICROSOFT", "URL=jdbc:sqlserver://serverholder;DATABASE=dbNameholder;LOGINTIMEOUT=0;DRIVER_NAME=com.microsoft.sqlserver.jdbc.SQLServerDriver");
            this.put("ORACLE", "URL=jdbc:oracle:thin:/@serverholder:dbNameholder;DRIVER_NAME=oracle.jdbc.OracleDriver");
            this.put("ORACLEADVANCED", "URL=jdbc:oracle:thin:@serverholder;DRIVER_NAME=oracle.jdbc.OracleDriver");
            this.put("DB2", "URL=jdbc:db2://serverholder/dbNameholder;DRIVER_NAME=com.ibm.db2.jcc.DB2Driver");
        }
    };
    private static final PogoLogger log = PogoLogger.getLogger();
    private static final String CONNECTION_SEARCH_PATH = "CAMID(\":\")/dataSource[@name='ZIPI']/dataSourceConnection";
    private static final String CONNECTION_IPADATA_SEARCH_PATH = "CAMID(\":\")/dataSource[@name='IPADATA']/dataSourceConnection";
    private static final String CREDENTIALS_SEARCH_PATH = "CAMID(\":\")/dataSource[@name='ZIPI']/dataSourceConnection/dataSourceSignon[@name='ZIPI']";
    private static final String DRIVER_NAME = ";DRIVER_NAME=";
    private static final String JDBC_PREFIX = "jdbc:";
    private static final int NOT_FOUND = -1;
    private final CAMUtils camUtils;
    private String connection;
    private Properties credentials;

    public ZipiDatabaseCMConfiguration() {
        this(new CAMUtils());
    }

    ZipiDatabaseCMConfiguration(CAMUtils camUtils) {
        this.camUtils = camUtils;
    }

    public boolean hasConnection() {
        return this.getDatabaseConnection() != null;
    }

    protected String getDatabaseConnection() {
        HashMap<String, String> csProperties;
        this.enableIPADrill();
        this.queryConnection(false);
        ZipiMBeanConfig config = (ZipiMBeanConfig)ZipiFactory.getConfig();
        if (this.connection == null && config.isIPAEnabled() && (csProperties = config.getCMProperties()) != null && !csProperties.isEmpty()) {
            this.credentials = ZipiUtils.createConnectionProperties(csProperties.get("username"), csProperties.get("password"));
            if (csProperties.get("username") != null && csProperties.get("password") != null) {
                this.credentials.put("user", csProperties.get("username"));
                this.credentials.put("password", csProperties.get("password"));
            }
            String dbName = csProperties.get("name");
            String databaseType = csProperties.get("databaseType");
            String server = csProperties.get("server");
            String advancedProperties = csProperties.get("advancedProperties");
            String sslEnabled = csProperties.get("sslEnabled");
            log.debug(new Object[]{"getDatabaseConnection:" + sslEnabled + "; advancedProperties:" + advancedProperties});
            this.getJDBConnectionString(databaseType, dbName, server, sslEnabled, advancedProperties);
        }
        return this.connection;
    }

    public synchronized void queryConnection(boolean reconfig) {
        if (!reconfig) {
            if (this.connection == null) {
                this.connection = this.queryCM(CONNECTION_SEARCH_PATH, "connectionString", "searchPath");
            }
        } else {
            this.connection = this.queryCM(CONNECTION_SEARCH_PATH, "connectionString", "searchPath");
        }
    }

    public synchronized void enableIPADrill() {
        String zipiDataConnection = this.queryCM(CONNECTION_IPADATA_SEARCH_PATH, "connectionString", "searchPath");
        if (zipiDataConnection != null && !zipiDataConnection.isEmpty()) {
            log.debug(new Object[]{"enableIPADrill at:" + zipiDataConnection});
            ZipiFactory.getConfig().enableIPADrill();
        }
    }

    private void getJDBConnectionString(String databaseType, String dbName, String server, String sslEnabled, String advancedProperties) {
        this.connection = JDBCConnectString.get(databaseType.toUpperCase());
        if (this.connection != null) {
            if ("ORACLEADVANCED".equalsIgnoreCase(databaseType)) {
                this.connection = this.connection.replace("serverholder", server);
                if ("true".equalsIgnoreCase(sslEnabled)) {
                    StringBuffer nc = new StringBuffer();
                    int driveStart = this.connection.indexOf(DRIVER_NAME);
                    nc.append(this.connection.substring(0, driveStart));
                    nc.append(";sslConnection=true;");
                    nc.append(this.connection.substring(driveStart));
                    this.connection = nc.toString();
                }
            } else {
                this.connection = this.connection.replace("serverholder", server);
                this.connection = this.connection.replace("dbNameholder", dbName);
                StringBuffer nc = new StringBuffer();
                if ("true".equalsIgnoreCase(sslEnabled)) {
                    int driveStart = this.connection.indexOf(DRIVER_NAME);
                    nc.append(this.connection.substring(0, driveStart));
                    if ("Microsoft".equalsIgnoreCase(databaseType)) {
                        nc.append(";applicationName=IBM_C11_IPPA;");
                    } else if ("DB2".equalsIgnoreCase(databaseType)) {
                        nc.append(";sslConnection=true;clientProgramName=IBM_C11_IPPA;");
                    } else {
                        log.error(new Object[]{"None supported database for SSL connection:" + databaseType});
                    }
                    nc.append(this.connection.substring(driveStart));
                    this.connection = nc.toString();
                }
            }
            if (advancedProperties != null && advancedProperties.length() > 5) {
                this.connection = this.connection + advancedProperties;
            }
            log.debug(new Object[]{"getJDBConnecionString:" + this.connection});
        } else {
            log.error(new Object[]{"Unknown zipi database type"});
        }
    }

    private String queryCM(String searchPath, String ... properties) {
        try {
            Element cmResponse = this.sendQuery(searchPath, properties);
            Node responseValue = cmResponse.selectSingleNode("//" + properties[0] + "/value");
            return responseValue != null ? responseValue.getText() : null;
        }
        catch (Exception e) {
            log.warn("Failed to query CM: ", (Throwable)e);
            return null;
        }
    }

    private Element sendQuery(String searchPath, String ... properties) throws CommandExecutionException {
        ContentManagerQueryCommand cmQuery = this.createQuery(searchPath, properties);
        cmQuery.execute();
        return cmQuery.getQueryResponseElement();
    }

    private ContentManagerQueryCommand createQuery(String searchPath, String ... properties) {
        ContentManagerQueryCommand query = new ContentManagerQueryCommand(searchPath);
        for (String property : properties) {
            query.addQueryPropertyName(property);
        }
        query.setDoTrustedRequest(true);
        return query;
    }

    public String getDriver() {
        String connectionString = this.getDatabaseConnection();
        return this.getDriver(connectionString);
    }

    private String getDriver(String cs) {
        int pos = cs.indexOf(DRIVER_NAME);
        return pos == -1 ? null : cs.substring(pos + DRIVER_NAME.length());
    }

    public String getUrl() {
        String connectionString = this.getDatabaseConnection();
        log.debug(new Object[]{"Original Connection: " + String.valueOf(connectionString)});
        if (connectionString == null) {
            return null;
        }
        int urlStart = this.findJdbcPrefix(connectionString);
        if (urlStart == -1) {
            return null;
        }
        int urlDriveStart = connectionString.indexOf(DRIVER_NAME);
        String ret = connectionString.substring(urlStart, urlDriveStart);
        log.debug(new Object[]{"getUrl to connect: " + ret});
        return ret;
    }

    private int findJdbcPrefix(String connectionString) {
        int jdbcPrefixPos = connectionString.indexOf(JDBC_PREFIX);
        if (jdbcPrefixPos == -1) {
            log.warn(new Object[]{"JDBC prefix not found in database connection string: ", connectionString});
        }
        return jdbcPrefixPos;
    }

    public Properties getCredentials() {
        if (this.credentials == null) {
            this.credentials = this.createCredentialProperties();
        }
        return this.credentials;
    }

    private Properties createCredentialProperties() {
        Element credentials = this.getDecryptedDatabaseCredentials();
        return credentials != null ? this.createProperties(credentials) : null;
    }

    private Element getDecryptedDatabaseCredentials() {
        String credentials = this.queryCM(CREDENTIALS_SEARCH_PATH, "credentials");
        return credentials != null ? this.parseCredentials(credentials) : null;
    }

    private Element parseCredentials(String encryptedCredentialsXml) {
        log.debug(new Object[]{"Parsing credentials: ", encryptedCredentialsXml});
        try {
            String encryptedValue = this.parseEncryptedValue(encryptedCredentialsXml);
            String decryptedValue = this.camUtils.decrypt(encryptedValue);
            return this.parseXml(decryptedValue);
        }
        catch (Exception e) {
            log.warn("Failed to parse credentials: ", (Throwable)e);
            return null;
        }
    }

    private String parseEncryptedValue(String encryptedCredentialsXml) throws DocumentException {
        Element encryptedCredentialsElement = this.parseXml(encryptedCredentialsXml);
        return encryptedCredentialsElement.elementText("encryptedValue");
    }

    private Element parseXml(String decryptedCredentials) throws DocumentException {
        Document doc = DocumentHelper.parseText((String)decryptedCredentials);
        return doc.getRootElement();
    }

    protected Properties createProperties(Element credentials) {
        String username = credentials.elementText("username");
        String password = credentials.elementText("password");
        return ZipiUtils.createConnectionProperties(username, password);
    }
}

