/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.pogo.zipi.impl;

import com.cognos.cclcfgapi.CCLConfigurationException;
import com.cognos.pogo.monitoring.jmx.JMXDispatcher;
import com.cognos.pogo.pdk.Configuration;
import com.cognos.pogo.pdk.PogoEngine;
import com.cognos.pogo.transport.PogoServlet;
import com.cognos.pogo.util.PogoLogger;
import com.ibm.cognos.pogo.zipi.Storage;
import com.ibm.cognos.pogo.zipi.ZipiConfig;
import com.ibm.cognos.pogo.zipi.ZipiFactory;
import com.ibm.cognos.pogo.zipi.impl.IPADataCleanInterval;
import com.ibm.cognos.pogo.zipi.impl.IPADataExpireThreshold;
import com.ibm.cognos.pogo.zipi.impl.IPAEnabledParameter;
import com.ibm.cognos.pogo.zipi.impl.ZipiClient;
import com.ibm.cognos.pogo.zipi.impl.ZipiCollectionIntervalParameter;
import com.ibm.cognos.pogo.zipi.impl.ZipiCollectionTimeoutFactorParameter;
import com.ibm.cognos.pogo.zipi.impl.ZipiDatabaseConfigurationImpl;
import com.ibm.cognos.pogo.zipi.impl.ZipiDiscardThresholdIncrementParameter;
import com.ibm.cognos.pogo.zipi.impl.ZipiDiscardThresholdParameter;
import com.ibm.cognos.pogo.zipi.impl.ZipiEnabledParameter;
import com.ibm.cognos.pogo.zipi.impl.ZipiFormParametersToSave;
import com.ibm.cognos.pogo.zipi.impl.ZipiMaxDiscardThresholdParameter;
import com.ibm.cognos.pogo.zipi.impl.ZipiMaxEventsAllowedParameter;
import com.ibm.cognos.pogo.zipi.impl.ZipiSendingRequestEnabled;
import com.ibm.cognos.pogo.zipi.impl.ZipiTestModeParameter;
import com.ibm.cognos.pogo.zipi.impl.ZipiUtils;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import org.dom4j.Element;

public class ZipiMBeanConfig
implements ZipiConfig {
    private static final PogoLogger log = PogoLogger.getLogger();
    public static final String ZIPI_DB_CONFIG_PARAMETER_NAME = "ZIP";
    HashMap<String, String> zipiDBInfo = new HashMap();
    private ZipiEnabledParameter enabledParameter = new ZipiEnabledParameter();
    private boolean isEnabled = this.enabledParameter.isEnabled();
    private IPAEnabledParameter enabledIPAParameter = new IPAEnabledParameter();
    private boolean ipaEnabled = this.enabledIPAParameter.isEnabled();
    private IPADataExpireThreshold ipaDataAgeS = new IPADataExpireThreshold();
    private int ipaDataExpireThreshold = this.ipaDataAgeS.getIntValue();
    private IPADataCleanInterval ipaDatCleanIntervalS = new IPADataCleanInterval();
    private int ipaDataCleanInterval = this.ipaDatCleanIntervalS.getIntValue();
    private ZipiFormParametersToSave formParametersToSave = new ZipiFormParametersToSave();
    private List<String> formParameterNames = this.formParametersToSave.getNames();
    private ZipiCollectionIntervalParameter collectionIntervalParameter = new ZipiCollectionIntervalParameter();
    private int collectionIntervalInSeconds = this.collectionIntervalParameter.getIntValue();
    private ZipiCollectionTimeoutFactorParameter collectionTimeoutFactorParameter = new ZipiCollectionTimeoutFactorParameter();
    private int collectionTimeoutFactor = this.collectionTimeoutFactorParameter.getIntValue();
    private ZipiDiscardThresholdParameter discardThresholdParameter = new ZipiDiscardThresholdParameter();
    private int configuredDiscardThresholdInMillis;
    private int dynamicDiscardThresholdInMillis = this.configuredDiscardThresholdInMillis = this.discardThresholdParameter.getIntValue();
    private ZipiMaxDiscardThresholdParameter maxDiscardThresholdParameter = new ZipiMaxDiscardThresholdParameter();
    private int maxDiscardThresholdInMillis = this.maxDiscardThresholdParameter.getIntValue();
    private ZipiDiscardThresholdIncrementParameter discardThresholdIncrementParameter = new ZipiDiscardThresholdIncrementParameter();
    private int discardThresholdIncrementInMillis = this.discardThresholdParameter.getIntValue();
    private ZipiMaxEventsAllowedParameter maxEventsAllowedParameter = new ZipiMaxEventsAllowedParameter();
    private int maxEventsAllowed = this.maxEventsAllowedParameter.getIntValue();
    private ZipiTestModeParameter testModeParameter = new ZipiTestModeParameter();
    private boolean isInTestMode = this.testModeParameter.isEnabled();
    private ZipiSendingRequestEnabled sendingRequestEnabled = new ZipiSendingRequestEnabled();
    private boolean isSendingRequestEnabled = this.sendingRequestEnabled.isEnabled();
    private ZipiDatabaseConfigurationImpl dbConfig = new ZipiDatabaseConfigurationImpl();
    private Collection<JMXDispatcher> dispatchers;
    private Boolean isIPADATADefined = null;
    PogoEngine pogoEngine = null;

    @Override
    public void reconfigure(Configuration configuration) {
        this.enabledParameter.updateConfiguration(configuration);
        this.isEnabled = this.enabledParameter.isEnabled();
        this.enabledIPAParameter.updateConfiguration(configuration);
        this.ipaEnabled = this.enabledIPAParameter.isEnabled();
        this.ipaDataAgeS.updateConfiguration(configuration);
        this.ipaDataExpireThreshold = this.ipaDataAgeS.getIntValue();
        this.ipaDatCleanIntervalS.updateConfiguration(configuration);
        this.ipaDataCleanInterval = this.ipaDatCleanIntervalS.getIntValue();
        this.formParametersToSave.updateConfiguration(configuration);
        this.formParameterNames = this.formParametersToSave.getNames();
        this.collectionIntervalParameter.updateConfiguration(configuration);
        this.collectionIntervalInSeconds = this.collectionIntervalParameter.getIntValue();
        this.collectionTimeoutFactorParameter.updateConfiguration(configuration);
        this.collectionTimeoutFactor = this.collectionTimeoutFactorParameter.getIntValue();
        this.discardThresholdParameter.updateConfiguration(configuration);
        int previousValue = this.configuredDiscardThresholdInMillis;
        this.configuredDiscardThresholdInMillis = this.discardThresholdParameter.getIntValue();
        if (this.configuredDiscardThresholdInMillis != previousValue) {
            this.dynamicDiscardThresholdInMillis = this.configuredDiscardThresholdInMillis;
        }
        this.maxDiscardThresholdParameter.updateConfiguration(configuration);
        this.maxDiscardThresholdInMillis = this.maxDiscardThresholdParameter.getIntValue();
        this.discardThresholdIncrementParameter.updateConfiguration(configuration);
        this.discardThresholdIncrementInMillis = this.discardThresholdIncrementParameter.getIntValue();
        this.maxEventsAllowedParameter.updateConfiguration(configuration);
        this.maxEventsAllowed = this.maxEventsAllowedParameter.getIntValue();
        this.testModeParameter.updateConfiguration(configuration);
        this.isInTestMode = this.testModeParameter.isEnabled();
        this.sendingRequestEnabled.updateConfiguration(configuration);
        this.isSendingRequestEnabled = this.sendingRequestEnabled.isEnabled();
        this.dbConfig.reconfigure(configuration);
        if (this.isIPAEnabled()) {
            try {
                this.getDefaultZIPIDatabase(configuration);
                try {
                    this.pogoEngine = PogoServlet.getPogoEngineStatic();
                }
                catch (Exception e) {
                    log.debug(new Object[]{"pogo engine is not ready yet, wait..."});
                }
                if (this.pogoEngine == null) {
                    return;
                }
                if (this.pogoEngine.getReadyToProcess() || ZipiFactory.getConfig().isInTestMode()) {
                    ZipiClient zipiClient = new ZipiClient();
                    zipiClient.initialize();
                    this.dbConfig.getCMConfig().enableIPADrill();
                    this.dbConfig.getCMConfig().queryConnection(true);
                }
            }
            catch (CCLConfigurationException e) {
                log.error(new Object[]{e.getLocalizedMessage()});
            }
            catch (Exception e) {
                log.error(new Object[]{e.getLocalizedMessage()});
            }
        }
    }

    private void getDefaultZIPIDatabase(Configuration configuration) throws CCLConfigurationException {
        String cmURL = configuration.getICCLConfiguration().getValue("contentManager", true, true);
        Element instance = configuration.getICCLConfiguration().getValueElement("NC", true);
        this.zipiDBInfo = ZipiUtils.getDatabaseProps(instance);
        if ((this.zipiDBInfo == null || this.zipiDBInfo.isEmpty()) && configuration.getICCLConfiguration() != null && (instance = configuration.getICCLConfiguration().getValueElement("CM", true)) != null) {
            this.zipiDBInfo = ZipiUtils.getDatabaseProps(instance);
        }
        this.zipiDBInfo.put("CMURL", cmURL);
    }

    public HashMap<String, String> getCMProperties() {
        return this.zipiDBInfo;
    }

    @Override
    public boolean isZipiEnabled() {
        return (this.ipaEnabled || this.isEnabled) && this.dynamicDiscardThresholdInMillis < this.maxDiscardThresholdInMillis;
    }

    @Override
    public boolean isZipiInternalEnabled() {
        return this.isEnabled && this.dynamicDiscardThresholdInMillis < this.maxDiscardThresholdInMillis;
    }

    @Override
    public boolean isIPAEnabled() {
        return this.ipaEnabled;
    }

    @Override
    public boolean isZipiEnabledForCollection() {
        return (this.ipaEnabled || this.isEnabled) && ZipiFactory.getStorage() != Storage.NULL;
    }

    @Override
    public boolean isSendingRequestEnabled() {
        return this.ipaEnabled || this.isSendingRequestEnabled;
    }

    @Override
    public List<String> getFormParametersNames() {
        return this.formParameterNames;
    }

    @Override
    public int getCollectionIntervalInSeconds() {
        return this.collectionIntervalInSeconds;
    }

    @Override
    public int getCollectionTimeoutInSecs() {
        return this.collectionTimeoutFactor * this.getCollectionIntervalInSeconds();
    }

    @Override
    public int getDiscardThresholdInMillis() {
        return this.dynamicDiscardThresholdInMillis;
    }

    @Override
    public int getMaxDiscardThresholdInMillis() {
        return this.maxDiscardThresholdInMillis;
    }

    @Override
    public void increaseDiscardThreshold() {
        if (this.dynamicDiscardThresholdInMillis == this.maxDiscardThresholdInMillis) {
            return;
        }
        this.dynamicDiscardThresholdInMillis = Math.min(this.dynamicDiscardThresholdInMillis + this.getNextIncrement(), this.maxDiscardThresholdInMillis);
        log.debug(new Object[]{"Discard threshold increased to ", this.dynamicDiscardThresholdInMillis, " ms"});
    }

    private int getNextIncrement() {
        return this.dynamicDiscardThresholdInMillis == this.configuredDiscardThresholdInMillis ? this.discardThresholdIncrementInMillis : this.dynamicDiscardThresholdInMillis - this.configuredDiscardThresholdInMillis;
    }

    @Override
    public void decreaseDiscardThreshold() {
        if (this.dynamicDiscardThresholdInMillis == this.configuredDiscardThresholdInMillis) {
            return;
        }
        this.dynamicDiscardThresholdInMillis -= this.getNextDecrement();
        if (this.dynamicDiscardThresholdInMillis < this.configuredDiscardThresholdInMillis + this.discardThresholdIncrementInMillis) {
            this.dynamicDiscardThresholdInMillis = this.configuredDiscardThresholdInMillis;
        }
        log.debug(new Object[]{"Discard threshold decreased to ", this.dynamicDiscardThresholdInMillis, " ms"});
    }

    private int getNextDecrement() {
        return (int)Math.round((double)(this.dynamicDiscardThresholdInMillis - this.configuredDiscardThresholdInMillis) * 3.0 / 4.0);
    }

    @Override
    public int getMaxEventsAllowed() {
        return this.maxEventsAllowed;
    }

    @Override
    public ZipiDatabaseConfigurationImpl getDatabaseConfig() {
        this.dbConfig = new ZipiDatabaseConfigurationImpl();
        return this.dbConfig;
    }

    @Override
    public boolean isInTestMode() {
        return this.isInTestMode;
    }

    public String toString() {
        return this.getClass().getSimpleName() + "(isEnabled=" + this.isEnabled + ",collectionIntervalInSeconds=" + this.collectionIntervalInSeconds + ",collectionTimeoutFactor=" + this.collectionTimeoutFactor + ",configuredDiscardThresholdInMillis=" + this.configuredDiscardThresholdInMillis + ",dynamicDiscardThresholdInMillis=" + this.dynamicDiscardThresholdInMillis + ",maxDiscardThresholdInMillis=" + this.maxDiscardThresholdInMillis + ",discardThresholdIncrementInMillis=" + this.discardThresholdIncrementInMillis + ",ipaDataExpireThreshold=" + this.ipaDataExpireThreshold + ",ipaDataCleanInterval=" + this.ipaDataCleanInterval + ",maxEventsAllowed=" + this.maxEventsAllowed + ",isInTestMode=" + this.isInTestMode + ",isSendingRequestEnabled=" + this.isSendingRequestEnabled + ",isIPAEnabled=" + this.ipaEnabled + ",isZIPIDATADefined=" + this.isIPADATADefined + ")";
    }

    @Override
    public void setJMXDispatchers(Collection<JMXDispatcher> dispatchers) {
        this.dispatchers = dispatchers;
    }

    @Override
    public Collection<JMXDispatcher> getJMXDispatchers() {
        return this.dispatchers;
    }

    @Override
    public void enableIPADrill() {
        this.isIPADATADefined = true;
    }

    @Override
    public boolean isIPADATADefined() {
        if (this.isIPADATADefined == null && this.pogoEngine != null && this.pogoEngine.getReadyToProcess()) {
            this.dbConfig.getCMConfig().enableIPADrill();
        }
        if (this.isIPADATADefined == null) {
            return false;
        }
        return this.isIPADATADefined;
    }

    @Override
    public long getCollectionCleanIntervalInSeconds() {
        return this.ipaDataCleanInterval;
    }

    @Override
    public void setCollectionCleanIntervalInSeconds(int ipaDataCleanInterval) {
        this.ipaDataCleanInterval = ipaDataCleanInterval;
    }

    @Override
    public int getDataExpireThresholdInSeconds() {
        return this.ipaDataExpireThreshold;
    }

    @Override
    public void setDataExpireThresholdInSeconds(int ipaDataExpireThreshold) {
        this.ipaDataExpireThreshold = ipaDataExpireThreshold;
    }
}

