/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.pogo.zipi.impl;

import com.cognos.p2plb.model.NodeID;
import com.cognos.pogo.pdk.MessageContext;
import com.cognos.pogo.util.PogoLogger;
import com.ibm.cognos.pogo.zipi.RequestAdapter;
import com.ibm.cognos.pogo.zipi.ThreadContext;
import com.ibm.cognos.pogo.zipi.ZipiEvent;
import com.ibm.cognos.pogo.zipi.ZipiFactory;
import com.ibm.cognos.pogo.zipi.ZipiID;
import com.ibm.cognos.pogo.zipi.ZipiTimer;
import com.ibm.cognos.pogo.zipi.impl.ZipiMBeanEvent;
import com.ibm.cognos.pogo.zipi.impl.ZipiMBeanLogger;
import com.ibm.cognos.pogo.zipi.impl.ZipiStorage;
import java.util.Vector;
import org.apache.commons.httpclient.Header;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.lang.StringUtils;
import org.apache.log.Priority;

public class ZipiMBeanTimer
implements ZipiTimer {
    private static PogoLogger log = PogoLogger.getLogger();
    private final ThreadContext context;
    private final ZipiMBeanLogger zipiLogger;
    private final ZipiMBeanEvent event;
    private boolean isActive;

    public ZipiMBeanTimer() {
        this.isActive = false;
        this.zipiLogger = null;
        this.context = null;
        this.event = null;
    }

    public ZipiMBeanTimer(ZipiMBeanLogger zipiLogger, ThreadContext context, RequestAdapter request) {
        this(zipiLogger, context, request.getStep());
        this.setAction(request.getSoapAction());
        this.setSource(request.getSource());
        this.setSourceService(request.getSourceService());
    }

    public ZipiMBeanTimer(ZipiMBeanLogger zipiLogger, ThreadContext context, String step) {
        context.setTimer(this);
        this.isActive = true;
        this.zipiLogger = zipiLogger;
        this.context = context;
        this.event = this.createEvent(step);
        context.setCurrentStep(this.event.getStep());
        this.setProcessID(ZipiFactory.getLocalProcessID());
        this.setSource(NodeID.getSelf().toString());
        this.setTargetService(ZipiStorage.getCurrentService());
        log.debug(new Object[]{this, ": timer created"});
    }

    private ZipiMBeanEvent createEvent(String step) {
        return this.zipiLogger.getStorage().createEvent(this.getZipiID(), step);
    }

    @Override
    public boolean isActive() {
        return this.isActive;
    }

    @Override
    public ZipiEvent stop() {
        log.debug(new Object[]{this, ": stop"});
        this.isActive = false;
        this.zipiLogger.getStorage().addEvent(this.getZipiID(), this.event);
        return this.event;
    }

    @Override
    public ZipiEvent stopAndClear() {
        log.debug(new Object[]{this, ": stopAndClear"});
        this.stop();
        this.clearCurrentContext();
        return this.event;
    }

    protected void clearCurrentContext() {
        if (!this.context.isEmpty()) {
            this.logWarning();
        }
        this.zipiLogger.getStorage().clearCurrentContext();
    }

    protected void logWarning() {
        log.warn(new Object[]{"stopAndClear() called on nested timer: ", this.event, ", ", this.context});
        if (log.isWarnEnabled()) {
            log.warn(new Object[]{"stopAndClear() stack trace: ", log.getStackTrace()});
        }
    }

    @Override
    public ZipiID getZipiID() {
        return this.context.getZipiId();
    }

    @Override
    public String getAction() {
        return this.event.getAction();
    }

    @Override
    public void setAction(String action) {
        this.event.setAction(action);
    }

    @Override
    public String getSource() {
        return this.event.getSource();
    }

    @Override
    public void setSource(String source) {
        this.event.setSource(source);
    }

    @Override
    public String getSourceService() {
        return this.event.getSourceService();
    }

    @Override
    public void setSourceService(String sourceService) {
        this.event.setSourceService(sourceService);
    }

    @Override
    public String getTargetService() {
        return this.event.getTargetService();
    }

    @Override
    public void setTargetService(String serviceName) {
        this.event.setTargetService(serviceName);
    }

    @Override
    public String getInitialStep() {
        return this.event.getStep();
    }

    @Override
    public String getCurrentStep() {
        return this.context.getCurrentStep();
    }

    @Override
    public String incrementAndGetCurrentStep() {
        return this.context.incrementAndGetCurrentStep();
    }

    @Override
    public void setCurrentStep(String step) {
        if (StringUtils.isNotEmpty((String)step)) {
            this.context.setCurrentStep(step);
        }
    }

    @Override
    public void setCurrentStep(int step) {
        this.context.setCurrentStep(step);
    }

    @Override
    public void updateAsyncContext(MessageContext mc) {
        if (this.getZipiID().shouldLog()) {
            int stepForAsyncContext = this.context.getCurrentStepAsInt() * 100;
            log.debug(new Object[]{this, ": updateAsyncContext: step=", stepForAsyncContext});
            mc.setProperty("zipi.step", (Object)String.valueOf(stepForAsyncContext));
            mc.setProperty("zipi.id", (Object)this.getZipiID());
        }
    }

    @Override
    public String getPassport() {
        return this.event.getPassport();
    }

    @Override
    public void setPassport(String passport) {
        this.event.setPassport(passport);
    }

    @Override
    public String getUsername() {
        return this.event.getUsername();
    }

    @Override
    public void setUsername(String username) {
        this.event.setUsername(username);
    }

    @Override
    public String getObjectPath() {
        return this.event.getObjectPath();
    }

    @Override
    public void setObjectPath(String objectPath) {
        this.event.setObjectPath(objectPath);
    }

    @Override
    public void addFormParameter(String name, Vector<String> values) {
        this.event.addFormParameter(name, values);
    }

    @Override
    public int getProcessID() {
        return this.event.getProcessID();
    }

    @Override
    public void setProcessID(int processID) {
        this.event.setProcessID(processID);
    }

    @Override
    @Deprecated
    public String getProcessName() {
        return this.event.getProcessName();
    }

    @Override
    @Deprecated
    public void setProcessName(String processName) {
    }

    @Override
    public void handleResponse(HttpMethod method) {
        Header stepHeader = method.getResponseHeader("zipi.step");
        String responseStep = stepHeader != null ? stepHeader.getValue() : null;
        log.debug(new Object[]{"Handling http method response: responseStep = ", responseStep});
        this.stopConnectionTimer(responseStep);
    }

    public ZipiEvent getEvent() {
        return this.event;
    }

    @Override
    public void stopConnectionTimer(String step) {
        boolean hasChildren = StringUtils.isNotEmpty((String)step);
        if (hasChildren) {
            this.context.setCurrentStep(step);
            this.event.setShouldDiscard(true);
        }
        this.stop();
        if (hasChildren) {
            this.event.setChildrenElapsedTime(this.event.getElapsedTime());
        }
    }

    @Override
    public void handleChildEvent(ZipiEvent event) {
        this.event.handleChildEvent(event);
    }

    public String toString() {
        return "ZipiMBeanTimer(" + this.hashCode() + ")";
    }

    @Override
    public void appendAction(String action) {
        StringBuilder newAction = new StringBuilder(this.event.getAction());
        newAction.append(": ");
        newAction.append(action);
        this.event.setAction(newAction.toString());
    }

    public static void setLoggerForTesting(PogoLogger log) {
        ZipiMBeanTimer.log = log;
    }

    public static void setLogPriority(Priority priority) {
        log.setPriority(priority);
    }

    @Override
    public void handleSubsequentTimerCreated() {
        this.event.handleSubsequentEventCreated();
    }
}

