/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.pogo.zipi.impl;

import com.cognos.p2plb.model.NodeID;
import com.cognos.pogo.util.PogoLogger;
import com.ibm.cognos.pogo.zipi.Storage;
import com.ibm.cognos.pogo.zipi.ThreadContext;
import com.ibm.cognos.pogo.zipi.ZipiConfig;
import com.ibm.cognos.pogo.zipi.ZipiEvent;
import com.ibm.cognos.pogo.zipi.ZipiEvents;
import com.ibm.cognos.pogo.zipi.ZipiFactory;
import com.ibm.cognos.pogo.zipi.ZipiID;
import com.ibm.cognos.pogo.zipi.ZipiReader;
import com.ibm.cognos.pogo.zipi.impl.BulkEventParameters;
import com.ibm.cognos.pogo.zipi.impl.EventTracing;
import com.ibm.cognos.pogo.zipi.impl.Marker;
import com.ibm.cognos.pogo.zipi.impl.Zipi;
import com.ibm.cognos.pogo.zipi.impl.ZipiMBean;
import com.ibm.cognos.pogo.zipi.impl.ZipiMBeanEvent;
import com.ibm.cognos.pogo.zipi.impl.ZipiMBeanEvents;
import com.ibm.cognos.pogo.zipi.impl.ZipiMBeanID;
import com.ibm.cognos.pogo.zipi.impl.ZipiStorageStats;
import com.ibm.cognos.pogo.zipi.impl.ZipiThreadContext;
import com.ibm.cognos.pogo.zipi.impl.ZipiWallTime;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.apache.log.Priority;

public class ZipiStorage
implements Storage,
ZipiReader {
    private static PogoLogger log = PogoLogger.getLogger();
    public static final String ACTION_FOR_INVALID_CONTEXT_SWITCH = "Invalid context switch attempt";
    public static final String SERVICE_DISPATCHER = "Dispatcher";
    private volatile ConcurrentHashMap<ZipiID, ZipiMBeanEvents> eventSets = new ConcurrentHashMap();
    private ReadWriteLock actionsDataStructureLock = new ReentrantReadWriteLock();
    private Lock storageLock = this.actionsDataStructureLock.readLock();
    private Lock storageSwapLock = this.actionsDataStructureLock.writeLock();
    private final ThreadLocal<ThreadContext> threadContext = new ThreadLocal();
    private final Zipi mbean = new Zipi();
    private final EventTracing eventTracing;
    private final ZipiStorageStats storageStats;
    private final ZipiWallTime wallTime;
    private final ZipiConfig zipiConfig;
    private static String srcUri;
    private static String staticService;
    private static ThreadLocal<String> currentService;

    public ZipiStorage(ZipiWallTime wallTime) {
        this(new EventTracing(), new ZipiStorageStats(wallTime), wallTime);
    }

    public ZipiStorage(EventTracing eventTracing, ZipiStorageStats storageStats, ZipiWallTime wallTime) {
        this.eventTracing = eventTracing;
        this.storageStats = storageStats;
        this.wallTime = wallTime;
        this.zipiConfig = ZipiFactory.getConfig();
        this.createInitialContext();
    }

    @Override
    public ZipiMBeanEvents getEventsFor(ZipiID zid) {
        log.debug(new Object[]{"Getting events for: ", zid});
        this.storageLock.lock();
        try {
            ZipiMBeanEvents zipiMBeanEvents = this.eventSets.get(zid);
            return zipiMBeanEvents;
        }
        finally {
            this.storageLock.unlock();
        }
    }

    @Override
    public ZipiMBeanEvent createEvent(ZipiID zid, String initialStep) {
        log.debug(new Object[]{"Creating new event, initial step: ", initialStep});
        ZipiMBeanEvent event = new ZipiMBeanEvent(initialStep, this.getCurrentTimeInNanos(), this.getCurrentTimeInMillis());
        this.eventTracing.handleEventCreated(zid, event);
        return event;
    }

    @Override
    public ZipiEvent createBulkEvent(ZipiID zid, String ... eventParameters) throws NumberFormatException, ArrayIndexOutOfBoundsException {
        return this.createBulkEvent(zid, new BulkEventParameters(eventParameters));
    }

    @Override
    public ZipiMBeanEvent createBulkEvent(ZipiID zid, BulkEventParameters bulkEventParameters) {
        return this.canBeSaved(bulkEventParameters, zid) ? this.saveBulkEvent(zid, bulkEventParameters) : null;
    }

    @Override
    public ZipiEvent createBulkEvent(ZipiID zid, Marker marker) {
        return this.createBulkEvent(zid, new BulkEventParameters(marker));
    }

    private boolean canBeSaved(BulkEventParameters bulkEventParameters, ZipiID zid) {
        return zid.shouldLog() && bulkEventParameters.canBeSaved(this.zipiConfig.getDiscardThresholdInMillis());
    }

    private boolean canBeSaved(ZipiEvent event, ZipiID zid) {
        return zid.shouldLog() && event.canBeSaved(this.zipiConfig.getDiscardThresholdInMillis());
    }

    private ZipiMBeanEvent saveBulkEvent(ZipiID zid, BulkEventParameters bulkEventParameters) {
        ZipiMBeanEvent bulkEvent = new ZipiMBeanEvent(bulkEventParameters);
        this.saveEvent(zid, bulkEvent);
        this.getCurrentContext().notifyPreviousTimers();
        return bulkEvent;
    }

    @Override
    public void addEvent(ZipiID zid, ZipiMBeanEvent event) {
        this.maybeSaveEvent(zid, event);
        this.getCurrentContext().pop();
        this.getCurrentContext().getTimer().handleChildEvent(event);
    }

    private void maybeSaveEvent(ZipiID zid, ZipiMBeanEvent event) {
        event.stop(this.getCurrentTimeInNanos(), this.getCurrentTimeInMillis());
        if (this.canBeSaved(event, zid)) {
            this.saveEvent(zid, event);
            this.eventTracing.handleEventSaved(zid, event);
        }
    }

    private void saveEvent(ZipiID zid, ZipiMBeanEvent event) {
        log.debug(new Object[]{"Saving event: ", zid, ", ", event});
        this.getOrCreateEventsFor(zid).add(event);
        this.storageStats.handleEventSaved();
    }

    private ZipiMBeanEvents getOrCreateEventsFor(ZipiID zid) {
        ZipiMBeanEvents events = this.getEventsFor(zid);
        return events != null ? events : this.addEventsFor(zid);
    }

    private ZipiMBeanEvents addEventsFor(ZipiID zid) {
        ZipiMBeanEvents events = new ZipiMBeanEvents(zid);
        this.storageLock.lock();
        try {
            this.eventSets.put(zid, events);
        }
        finally {
            this.storageLock.unlock();
        }
        return events;
    }

    @Override
    public long getCurrentTimeInNanos() {
        return this.wallTime.getCurrentTimeInNanos();
    }

    private long getCurrentTimeInMillis() {
        return this.wallTime.getCurrentTimeInMillis();
    }

    @Override
    public void initialize() {
        this.mbean.initialize();
        this.eventTracing.initialize();
        this.storageStats.initialize(this);
        ZipiStorage.setCurrentService(null);
    }

    private void createInitialContext() {
        this.createContext(new ZipiMBeanID());
    }

    @Override
    public void reset() {
        this.clearAll();
        this.clearCurrentContext();
    }

    @Override
    public void clearAll() {
        this.storageLock.lock();
        try {
            this.eventSets.clear();
            this.storageStats.handleEventsCleared();
        }
        finally {
            this.storageLock.unlock();
        }
    }

    @Override
    public void clearCurrentContext() {
        log.debug(new Object[]{"clearCurrentContext"});
        this.threadContext.remove();
    }

    @Override
    public String[] getAllZipiIds() {
        this.storageLock.lock();
        try {
            String[] stringArray = this.toStringArray(this.eventSets.keySet());
            return stringArray;
        }
        finally {
            this.storageLock.unlock();
        }
    }

    private String[] toStringArray(Set<ZipiID> idSet) {
        ArrayList<String> idList = new ArrayList<String>(idSet.size());
        for (ZipiID id : idSet) {
            idList.add(id.toString());
        }
        return idList.toArray(new String[idList.size()]);
    }

    @Override
    public ZipiMBeanEvents getEventsFor(String id) {
        return this.getEventsFor(new ZipiMBeanID(id));
    }

    @Override
    public List<ZipiEvents> getAllEvents() {
        this.storageLock.lock();
        try {
            ArrayList<ZipiEvents> arrayList = new ArrayList<ZipiEvents>(this.eventSets.values());
            return arrayList;
        }
        finally {
            this.storageLock.unlock();
        }
    }

    @Override
    public void dump() {
        log.debug(new Object[]{"Dumping ZIPI Storage:"});
        this.storageLock.lock();
        try {
            for (Map.Entry<ZipiID, ZipiMBeanEvents> entry : this.eventSets.entrySet()) {
                this.dump(entry.getKey(), entry.getValue());
            }
        }
        finally {
            this.storageLock.unlock();
        }
    }

    private void dump(ZipiID zid, ZipiMBeanEvents events) {
        log.debug(new Object[]{"   Events for ZIPI ID: ", zid});
        events.dump("   ");
    }

    @Override
    public final ThreadContext getCurrentContext() {
        ThreadContext currentContext = this.getThreadContext();
        log.debug(new Object[]{"getCurrentContext: ", currentContext});
        return currentContext;
    }

    private ThreadContext getThreadContext() {
        ThreadContext context = this.threadContext.get();
        return context != null ? context : ThreadContext.NULL;
    }

    @Override
    public ThreadContext getOrCreateContext() {
        return this.getContext((String)null);
    }

    @Override
    public ThreadContext getContext(String id) {
        ThreadContext context = this.getCurrentContext();
        this.checkForInvalidContextSwitch(context, id);
        return context.isActive() ? context : this.createContext(id);
    }

    private void checkForInvalidContextSwitch(ThreadContext context, String id) {
        if (this.isInvalid(context, id)) {
            this.logInvalidContextSwitchAttempt(context, id);
        }
    }

    private boolean isInvalid(ThreadContext context, String id) {
        return context.isActive() && !context.isValid(id);
    }

    private void logInvalidContextSwitchAttempt(ThreadContext context, String id) {
        log.warn(new Object[]{"Invalid context switch attempt. ID=", id, " on ", context, ". "});
        this.createWarningEvent(context);
    }

    private void createWarningEvent(ThreadContext context) {
        ZipiMBeanEvent warningEvent = this.createEvent(context.getZipiId(), context.getCurrentStep());
        warningEvent.setAction(ACTION_FOR_INVALID_CONTEXT_SWITCH);
        this.maybeSaveEvent(context.getZipiId(), warningEvent);
    }

    @Override
    public ThreadContext getContext(ZipiID zid) {
        ThreadContext context = this.getCurrentContext();
        this.checkForInvalidContextSwitch(context, String.valueOf(zid));
        return context.isActive() ? context : this.createContext(zid);
    }

    private ThreadContext createContext(String id) {
        return this.createContext(new ZipiMBeanID(id));
    }

    private ThreadContext createContext(ZipiID zid) {
        ZipiThreadContext context = new ZipiThreadContext(zid);
        this.threadContext.set(context);
        log.debug(new Object[]{"createContext: ", context});
        return context;
    }

    public static void setCurrentService(String name) {
        log.debug(new Object[]{"setCurrentService: ", name});
        currentService.set(name);
    }

    public static String getCurrentService() {
        if (staticService == null) {
            return currentService.get();
        }
        return staticService;
    }

    public static void clearCurrentService() {
        currentService.remove();
    }

    public static String getSrcURI() {
        if (srcUri == null) {
            srcUri = NodeID.getSelf().getURI();
        }
        return srcUri;
    }

    public static void setSrcURI(String uri) {
        srcUri = uri;
    }

    @Override
    public void updateEvents(Collection<ZipiMBeanEvents> eventSets) {
        log.debug(new Object[]{"updateEvents"});
        if (this.zipiConfig.isZipiEnabled()) {
            this.addEventsToStorage(eventSets);
        }
    }

    private void addEventsToStorage(Collection<ZipiMBeanEvents> eventSets) {
        this.storageLock.lock();
        try {
            int nrOfEventsSaved = this.saveEvents(eventSets);
            this.storageStats.handleEventsSaved(nrOfEventsSaved);
        }
        finally {
            this.storageLock.unlock();
        }
    }

    private int saveEvents(Collection<ZipiMBeanEvents> eventSets) {
        int nrOfEventsSaved = 0;
        for (ZipiMBeanEvents eventSet : eventSets) {
            nrOfEventsSaved += this.saveEvents(eventSet);
        }
        return nrOfEventsSaved;
    }

    private int saveEvents(ZipiMBeanEvents eventSet) {
        int nrOfEventsSaved = 0;
        ZipiMBeanEvents events = this.getOrCreateEventsFor(eventSet.getZipiID());
        for (ZipiEvent event : eventSet) {
            if (!this.wasAbleToSave(event, events)) continue;
            ++nrOfEventsSaved;
        }
        return nrOfEventsSaved;
    }

    private boolean wasAbleToSave(ZipiEvent event, ZipiMBeanEvents events) {
        if (this.canBeSaved(event, events.getZipiID())) {
            return events.add(event);
        }
        return false;
    }

    @Override
    public void discardShortEvents() {
        log.debug(new Object[]{"discardShortEvents"});
        this.storageLock.lock();
        try {
            this.removeEventsFromStorage(this.zipiConfig.getDiscardThresholdInMillis());
        }
        finally {
            this.storageLock.unlock();
        }
    }

    private void removeEventsFromStorage(int discardThresholdInMillis) {
        int nrOfDiscardedEvents = this.discardEvents(discardThresholdInMillis);
        this.storageStats.handleEventsRemoved(nrOfDiscardedEvents);
    }

    private int discardEvents(int discardThresholdInMillis) {
        int nrOfDiscardedEvents = 0;
        for (ZipiMBeanEvents eventSet : this.eventSets.values()) {
            nrOfDiscardedEvents += eventSet.discardEvents(discardThresholdInMillis);
        }
        return nrOfDiscardedEvents;
    }

    @Override
    public boolean isEmpty() {
        this.storageLock.lock();
        try {
            boolean bl = this.eventSets.isEmpty();
            return bl;
        }
        finally {
            this.storageLock.unlock();
        }
    }

    @Override
    public Collection<ZipiMBeanEvents> drainEvents() {
        ConcurrentHashMap<ZipiID, ZipiMBeanEvents> oldMap;
        log.debug(new Object[]{"drainEvents"});
        this.storageSwapLock.lock();
        try {
            oldMap = this.eventSets;
            this.eventSets = new ConcurrentHashMap();
            this.storageStats.handleEventsCollected();
        }
        finally {
            this.storageSwapLock.unlock();
        }
        return this.getSerializableCollection(oldMap);
    }

    private Collection<ZipiMBeanEvents> getSerializableCollection(ConcurrentHashMap<ZipiID, ZipiMBeanEvents> map) {
        return new ArrayList<ZipiMBeanEvents>(map.values());
    }

    public static void setStaticService(String serviceName) {
        staticService = serviceName;
    }

    @Override
    public ZipiMBean getLocalMBean() {
        return this.mbean;
    }

    public static void setLoggerForTesting(PogoLogger log) {
        ZipiStorage.log = log;
    }

    public static void setLogPriority(Priority priority) {
        log.setPriority(priority);
    }

    @Override
    public int getCurrentNumberOfEvents() {
        return this.storageStats.getCurrentNumberOfEvents();
    }

    @Override
    public int getLastIntervalBetweenCollectionsInSecs() {
        return this.storageStats.getLastIntervalBetweenCollectionsInSecs();
    }

    @Override
    public int getTimeSinceLastCollectionInSecs() {
        return this.storageStats.getTimeSinceLastCollectionInSecs();
    }

    @Override
    public boolean hasCollectionTimedOut() {
        int collectionTimeoutInSecs = this.zipiConfig.getCollectionTimeoutInSecs();
        return this.getTimeSinceLastCollectionInSecs() >= collectionTimeoutInSecs || this.getLastIntervalBetweenCollectionsInSecs() >= collectionTimeoutInSecs;
    }

    static {
        currentService = new ThreadLocal();
        currentService.set(SERVICE_DISPATCHER);
    }
}

