/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.pogo.zipi.impl;

import com.cognos.pogo.util.PogoLogger;
import com.ibm.cognos.pogo.zipi.Storage;
import com.ibm.cognos.pogo.zipi.ZipiConfig;
import com.ibm.cognos.pogo.zipi.ZipiFactory;
import com.ibm.cognos.pogo.zipi.impl.ZipiStorageMonitor;
import com.ibm.cognos.pogo.zipi.impl.ZipiWallTime;
import java.util.concurrent.atomic.AtomicInteger;

public class ZipiStorageStats {
    private static final PogoLogger log = PogoLogger.getLogger();
    private final ZipiWallTime wallTime;
    private final AtomicInteger currentNumberOfEvents = new AtomicInteger();
    private long lastCollectionTimeInMillis;
    private int lastIntervalBetweenCollectionsInSecs;
    private final ZipiConfig zipiConfig;
    private final ZipiStorageMonitor storageMonitor;

    public ZipiStorageStats(ZipiWallTime wallTime) {
        this(wallTime, new ZipiStorageMonitor(), ZipiFactory.getConfig());
    }

    public ZipiStorageStats(ZipiWallTime wallTime, ZipiStorageMonitor storageMonitor, ZipiConfig zipiConfig) {
        this.storageMonitor = storageMonitor;
        this.wallTime = wallTime;
        this.zipiConfig = zipiConfig;
    }

    public void initialize(Storage zipiStorage) {
        log.debug(new Object[]{"initialize"});
        this.storageMonitor.start(zipiStorage);
    }

    public void handleEventSaved() {
        log.debug(new Object[]{"handleEventSaved: currentNumberOfEvents = ", this.currentNumberOfEvents});
        int newNumberOfEvents = this.currentNumberOfEvents.incrementAndGet();
        if (newNumberOfEvents == this.zipiConfig.getMaxEventsAllowed()) {
            this.storageMonitor.handleMaxEventsReached();
        }
    }

    public void handleEventsCleared() {
        log.debug(new Object[]{"handleEventsCleared: currentNumberOfEvents = ", this.currentNumberOfEvents});
        this.currentNumberOfEvents.set(0);
    }

    public void handleEventsSaved(int nrOfEvents) {
        log.debug(new Object[]{"handleEventsSaved: currentNumberOfEvents = ", this.currentNumberOfEvents});
        int previousCount = this.currentNumberOfEvents.get();
        int newCount = this.currentNumberOfEvents.addAndGet(nrOfEvents);
        this.checkMaxEventsReached(previousCount, newCount);
    }

    private void checkMaxEventsReached(int previousCount, int newCount) {
        int maxEventsAllowed = this.zipiConfig.getMaxEventsAllowed();
        if (previousCount < maxEventsAllowed && newCount >= maxEventsAllowed) {
            this.storageMonitor.handleMaxEventsReached();
        }
    }

    public void handleEventsRemoved(int nrOfEvents) {
        log.debug(new Object[]{"handleEventsRemoved: currentNumberOfEvents = ", this.currentNumberOfEvents, ", removing ", nrOfEvents});
        this.currentNumberOfEvents.addAndGet(0 - nrOfEvents);
    }

    public void handleEventsCollected() {
        log.debug(new Object[]{"handleEventsCollected: currentNumberOfEvents = ", this.currentNumberOfEvents});
        this.currentNumberOfEvents.set(0);
        this.updateCollectionTime();
    }

    private void updateCollectionTime() {
        if (this.hasLastCollection()) {
            this.lastIntervalBetweenCollectionsInSecs = this.getTimeSinceLastCollection();
        }
        this.lastCollectionTimeInMillis = this.wallTime.getCurrentTimeInMillis();
    }

    private boolean hasLastCollection() {
        return this.lastCollectionTimeInMillis > 0L;
    }

    private int getTimeSinceLastCollection() {
        return (int)ZipiWallTime.millisToSecs(this.wallTime.getCurrentTimeInMillis() - this.lastCollectionTimeInMillis);
    }

    public int getTimeSinceLastCollectionInSecs() {
        return this.hasLastCollection() ? this.getTimeSinceLastCollection() : 0;
    }

    public int getLastIntervalBetweenCollectionsInSecs() {
        return this.lastIntervalBetweenCollectionsInSecs;
    }

    public int getCurrentNumberOfEvents() {
        return this.currentNumberOfEvents.get();
    }
}

