/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.pogo.zipi.impl;

import com.cognos.pogo.util.PogoLogger;
import com.ibm.cognos.pogo.zipi.ThreadContext;
import com.ibm.cognos.pogo.zipi.ZipiID;
import com.ibm.cognos.pogo.zipi.ZipiTimer;
import com.ibm.cognos.pogo.zipi.impl.ZipiMBeanID;
import java.util.Stack;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.commons.lang.StringUtils;
import org.apache.log.Priority;

public class ZipiThreadContext
implements ThreadContext {
    private static final PogoLogger log = PogoLogger.getLogger();
    public static final int INVALID_ZIPI_STEP = -1;
    private final Stack<ZipiTimer> timers = new Stack();
    private final AtomicInteger currentStep = new AtomicInteger();
    private final ZipiID zid;
    private ZipiTimer lastTimer = ZipiTimer.NULL;

    public ZipiThreadContext(ZipiID zid) {
        this.zid = zid != null ? zid : new ZipiMBeanID();
    }

    @Override
    public ZipiID getZipiId() {
        return this.zid;
    }

    @Override
    public ZipiTimer getTimer() {
        return this.timers.isEmpty() ? ZipiTimer.NULL : this.timers.peek();
    }

    @Override
    public void setTimer(ZipiTimer timer) {
        log.debug(new Object[]{"Pushing timer: ", timer, " to ", this});
        this.notifyPreviousTimers();
        this.timers.push(timer);
    }

    @Override
    public void notifyPreviousTimers() {
        this.getTimer().handleSubsequentTimerCreated();
        this.lastTimer.handleSubsequentTimerCreated();
    }

    @Override
    public void pop() {
        if (this.timers.isEmpty()) {
            log.warn("No more timers in this thread context. Continuing with the last timer.", (Throwable)new IllegalStateException("Stack trace"));
        } else {
            this.lastTimer = this.timers.pop();
        }
        log.debug(new Object[]{"Popped timer: ", this.lastTimer, " from ", this});
    }

    @Override
    public boolean isValid(String id) {
        return this.timers.isEmpty() || StringUtils.isEmpty((String)id) || id.equals(this.zid.toString());
    }

    @Override
    public String getCurrentStep() {
        return String.valueOf(this.getCurrentStepAsInt());
    }

    @Override
    public int getCurrentStepAsInt() {
        return this.currentStep.get();
    }

    @Override
    public boolean isActive() {
        return true;
    }

    public String toString() {
        return "ZipiThreadContext(" + this.hashCode() + ", " + this.zid + ", " + this.timers.size() + " timers, current timer=" + this.getTimer() + ")";
    }

    public static void setLogPriority(Priority priority) {
        log.setPriority(priority);
    }

    @Override
    public void setCurrentStep(String step) {
        try {
            this.setCurrentStep(Integer.valueOf(step));
        }
        catch (NumberFormatException e) {
            log.warn("Invalid step: " + step, (Throwable)e);
            this.setCurrentStep(-1);
        }
    }

    @Override
    public void setCurrentStep(int step) {
        log.debug(new Object[]{this, ": setCurrentStep(", step, ")"});
        this.currentStep.set(step);
    }

    @Override
    public String incrementAndGetCurrentStep() {
        int newStep = this.currentStep.incrementAndGet();
        log.debug(new Object[]{this, ": next step incremented to: ", newStep});
        return String.valueOf(newStep);
    }

    @Override
    public boolean isEmpty() {
        return this.timers.isEmpty();
    }
}

