/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.pogo.zipi.impl;

import com.cognos.pogo.pdk.BasicHandler;
import com.cognos.pogo.pdk.Handler;
import com.cognos.pogo.pdk.MessageContext;
import com.cognos.pogo.pdk.PogoException;
import com.cognos.pogo.util.PogoLogger;
import com.ibm.cognos.pogo.zipi.ZipiFactory;
import com.ibm.cognos.pogo.zipi.ZipiID;
import com.ibm.cognos.pogo.zipi.ZipiTimer;
import com.ibm.cognos.pogo.zipi.impl.ZipiStorage;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.lang.StringUtils;
import org.dom4j.Attribute;
import org.dom4j.Element;

public class ZipiUtils {
    private static final PogoLogger log = PogoLogger.getLogger();

    public ZipiTimer addHeaders(HttpMethod method) {
        return ZipiUtils.addZipiHeaders(method);
    }

    public static ZipiTimer addZipiHeaders(HttpMethod method) {
        ZipiTimer zipiTimer = ZipiFactory.startConnectionTimer();
        if (zipiTimer.isActive()) {
            ZipiUtils.replaceRequestHeaders(zipiTimer.getZipiID(), method);
        }
        return zipiTimer;
    }

    private static void replaceRequestHeaders(ZipiID zid, HttpMethod method) {
        if (zid.shouldLog()) {
            ZipiUtils.replaceRequestHeader("zipi.id", zid.toString(), method);
            ZipiUtils.replaceRequestHeader("zipi.src", ZipiStorage.getSrcURI(), method);
            ZipiUtils.replaceRequestHeader("zipi.src_svc", ZipiStorage.getCurrentService(), method);
            ZipiUtils.replaceRequestHeader("zipi.step", ZipiUtils.getNextZipiStep(), method);
        }
    }

    private static void replaceRequestHeader(String headerName, String headerValue, HttpMethod method) {
        log.debug(new Object[]{"replaceRequestHeader: ", headerName, "=", headerValue});
        method.removeRequestHeader(headerName);
        if (headerValue != null) {
            method.setRequestHeader(headerName, headerValue);
        }
    }

    private static String getNextZipiStep() {
        ZipiTimer currentTimer = ZipiFactory.getCurrentTimer();
        return currentTimer.incrementAndGetCurrentStep();
    }

    public void invokeHandler(Handler handler, MessageContext mc) throws PogoException {
        this.setZipiCurrentService(handler);
        try {
            handler.invoke(mc);
        }
        finally {
            ZipiStorage.clearCurrentService();
        }
    }

    public void setZipiCurrentService(Handler handler) {
        String serviceName = this.getServiceName(handler);
        this.updateTargetService(serviceName);
        this.updateCurrentService(serviceName);
    }

    private void updateTargetService(String serviceName) {
        if (StringUtils.isEmpty((String)serviceName)) {
            return;
        }
        ZipiFactory.getCurrentTimer().setTargetService(serviceName);
    }

    private void updateCurrentService(String serviceName) {
        if (StringUtils.isEmpty((String)serviceName)) {
            serviceName = "Dispatcher";
        }
        ZipiStorage.setCurrentService(serviceName);
    }

    private String getServiceName(Handler handler) {
        BasicHandler basicHandler = handler instanceof BasicHandler ? (BasicHandler)handler : null;
        return basicHandler != null ? basicHandler.getParentServiceName() : null;
    }

    private static void addProperty(Properties properties, String name, String value) {
        if (value != null) {
            properties.put(name, value);
        }
    }

    public static Properties createConnectionProperties(String username, String password) {
        Properties connInfo = new Properties();
        ZipiUtils.addProperty(connInfo, "user", username);
        ZipiUtils.addProperty(connInfo, "password", password);
        return connInfo;
    }

    public static HashMap<String, String> getDatabaseProps(Element doc) {
        HashMap<String, String> props = new HashMap<String, String>();
        try {
            Element databaseInfo1 = ZipiUtils.getItemElementWithName(doc, "name", "database", false);
            if (databaseInfo1 == null) {
                return props;
            }
            Element databaseInfo2 = ZipiUtils.getItemElementWithName(databaseInfo1, "class", null, false);
            if (databaseInfo2 == null) {
                return props;
            }
            Attribute type = databaseInfo2.attribute("class");
            String databaseType = type.getValue();
            props.put("databaseType", databaseType);
            if ("OracleAdvanced".equalsIgnoreCase(databaseType)) {
                Element oracleString = ZipiUtils.getItemElementWithName(databaseInfo2, "name", "specifier", true);
                String oracle = oracleString.getText();
                props.put("server", oracle);
            } else {
                Element server = ZipiUtils.getItemElementWithName(databaseInfo2, "name", "server", true);
                props.put("server", server.getText());
                if (databaseInfo2 != null) {
                    Element name = ZipiUtils.getItemElementWithName(databaseInfo2, "name", "name", true);
                    if (name == null) {
                        name = ZipiUtils.getItemElementWithName(databaseInfo2, "name", "servicename", true);
                    }
                    if (name != null) {
                        props.put("name", name.getText());
                    }
                }
            }
            ZipiUtils.getUserName(props, databaseInfo2);
            Element sslEnabledEle = ZipiUtils.getItemElementWithName(databaseInfo2, "name", "SSLencryptionEnabled", true);
            props.put("sslEnabled", sslEnabledEle.getText());
            Element advancedProperties = ZipiUtils.getItemElementWithName(databaseInfo2, "name", "advancedProperties", false);
            log.debug(new Object[]{"advancedProperties----:" + ZipiUtils.getAdvancedValues(advancedProperties)});
            props.put("advancedProperties", ZipiUtils.getAdvancedValues(advancedProperties));
        }
        catch (Exception exception) {
            // empty catch block
        }
        return props;
    }

    private static String getAdvancedValues(Element ele) {
        StringBuffer ret = new StringBuffer();
        log.debug(new Object[]{"Adv:" + ele.toString()});
        List dd = ele.elements("value");
        log.debug(new Object[]{"value:" + dd.toString()});
        List params = ((Element)dd.get(0)).elements("parameter");
        for (int i = 0; i < params.size(); ++i) {
            Element p = (Element)params.get(i);
            Element v = p.element("value");
            Attribute n = p.attribute("name");
            ret.append(";");
            ret.append(n.getValue());
            ret.append("=");
            ret.append(v.getText());
        }
        return ret.toString();
    }

    private static void getUserName(HashMap<String, String> props, Element databaseInfo2) {
        Element user = ZipiUtils.getItemElementWithName(databaseInfo2, "name", "user", true);
        if (user != null) {
            Iterator iter = user.elementIterator();
            while (iter.hasNext()) {
                Element item = (Element)iter.next();
                if (!"credential".equalsIgnoreCase(item.getName())) continue;
                Iterator dataIter = item.elementIterator();
                while (dataIter.hasNext()) {
                    Element data = (Element)dataIter.next();
                    props.put(data.getName(), data.getText());
                }
            }
        }
    }

    private static Element getItemElementWithName(Element parent, String attr, String value, boolean children) {
        try {
            if (parent == null) {
                return null;
            }
            Iterator elementIterator = parent.elementIterator();
            while (elementIterator.hasNext()) {
                Element anElement = (Element)elementIterator.next();
                Attribute ss = anElement.attribute(attr);
                if ((ss == null || value != null) && !value.equalsIgnoreCase(ss.getValue())) continue;
                if (!children) {
                    return anElement;
                }
                Iterator iter = anElement.elementIterator();
                if (!iter.hasNext()) continue;
                return (Element)iter.next();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }
}

