/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.pogo.zipi.impl.collector;

import com.ibm.cognos.pogo.zipi.ZipiEvent;
import com.ibm.cognos.pogo.zipi.impl.ZipiDatabase;
import com.ibm.cognos.pogo.zipi.impl.collector.LookupBatchPreparedStatement;
import com.ibm.cognos.pogo.zipi.impl.collector.MultiColumnPrimaryKeyCache;
import com.ibm.cognos.pogo.zipi.impl.collector.ProcessMapper;
import com.ibm.cognos.pogo.zipi.impl.tables.ActivityTable;
import java.sql.SQLException;

public class Activities {
    private final MultiColumnPrimaryKeyCache activityCache;
    private final ProcessMapper processMapper;

    public Activities(ZipiDatabase zipiDB) {
        this(zipiDB, new ProcessMapper());
    }

    public Activities(ZipiDatabase zipiDB, ProcessMapper processMapper) {
        this.activityCache = ActivityTable.createPrimaryKeyCache(zipiDB);
        this.processMapper = processMapper;
    }

    public long saveActivity(ZipiEvent event) throws SQLException {
        String serviceName = event.getTargetService();
        String processName = this.processMapper.getProcessName(serviceName);
        return this.activityCache.saveRecord(event.getAction(), event.getObjectPath(), serviceName, processName);
    }

    public void prepareBatch() throws SQLException {
        this.activityCache.prepareBatch();
    }

    public void close() {
        this.activityCache.close();
    }

    public LookupBatchPreparedStatement getLookupBatchPreparedStatement() {
        return this.activityCache.getLookupBatchPreparedStatement();
    }

    public void createLookupSQLBuilder() throws SQLException {
        this.activityCache.createLookupSQLBuilder();
    }
}

