/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.pogo.zipi.impl.collector;

import com.ibm.cognos.pogo.zipi.impl.ZipiDatabase;
import com.ibm.cognos.pogo.zipi.impl.collector.BatchPreparedStatement;
import com.ibm.cognos.pogo.zipi.impl.tables.BucketsTable;
import com.ibm.cognos.pogo.zipi.impl.tables.LogRecordsTable;
import java.sql.SQLException;
import org.apache.commons.lang.StringUtils;

public class LogRecordBatchPreparedStatement
extends BatchPreparedStatement {
    public static final int SELF_TIME_BUCKET_INDEX = 12;
    public static final int ELAPSED_TIME_BUCKET_INDEX = 11;
    public static final int ACTIVITY_INDEX = 10;
    public static final int END_TIME_INDEX = 9;
    public static final int SELF_TIME_INDEX = 8;
    public static final int ELAPSED_TIME_INDEX = 7;
    public static final int START_TIME_INDEX = 6;
    public static final int STEP_INDEX = 5;
    public static final int THREAD_INDEX = 4;
    public static final int PROCESS_ID_INDEX = 3;
    public static final int SERVER_INDEX = 2;
    public static final int ZIPIID_INDEX = 1;
    public static final String LOG_RECORDS_PREPARE_STATEMENT = "INSERT INTO " + LogRecordsTable.TABLE_NAME + " (" + "ZIPIID" + "," + "SERVERNAMEID" + "," + "PROCESSID" + "," + "THREAD" + "," + "STEP" + "," + "STARTTIME" + "," + "ELAPSEDTIME" + "," + "SELFTIME" + "," + "ENDTIME" + "," + "ACTIVITYID" + "," + "ELAPSEDTIME_BUCKET_ID" + "," + "SELFTIME_BUCKET_ID" + ") VALUES (?,?,?,?,?,?,?,?,?,?,?,?)";

    public LogRecordBatchPreparedStatement(ZipiDatabase zipidb) throws SQLException {
        super(zipidb, LOG_RECORDS_PREPARE_STATEMENT);
    }

    private void setIndex(int paramIndex, long indexValue) throws SQLException {
        if (indexValue != -1L) {
            this.setLong(paramIndex, indexValue);
        } else {
            this.setNull(paramIndex, -5);
        }
    }

    public void addServer(long value) throws SQLException {
        this.setIndex(2, value);
    }

    public void addZipiId(String zipiID) throws SQLException {
        this.setStringIndex(1, zipiID);
    }

    public void addTime(long startTime, long elapsedTime, long childrenElapsedTime) throws SQLException {
        long selfTime = elapsedTime - childrenElapsedTime;
        this.setLong(6, startTime);
        this.setLong(7, elapsedTime);
        this.setLong(8, selfTime);
        this.setLong(9, startTime + elapsedTime);
        this.setIndex(11, BucketsTable.getBucketID(elapsedTime));
        this.setIndex(12, BucketsTable.getBucketID(selfTime));
    }

    public void addStep(String step) throws SQLException {
        this.setStringIndex(5, step);
    }

    public void addThread(String thread) throws SQLException {
        this.setStringIndex(4, StringUtils.left((String)thread, (int)50));
    }

    public void addProcessId(int processId) throws SQLException {
        this.setInt(3, processId);
    }

    public void addActivity(long value) throws SQLException {
        this.setIndex(10, value);
    }
}

