/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.pogo.zipi.impl.collector;

import com.cognos.pogo.util.StringUtils;
import com.ibm.cognos.pogo.zipi.impl.ZipiDatabase;
import com.ibm.cognos.pogo.zipi.impl.collector.LRUCache;
import com.ibm.cognos.pogo.zipi.impl.collector.LookupBatchPreparedStatement;
import com.ibm.cognos.pogo.zipi.impl.collector.LookupSQLBuilder;
import java.sql.SQLException;

public class LookupCache {
    private final ZipiDatabase zipiDB;
    private final String tableName;
    private final String idColumn;
    private final String nameColumn;
    private final int maxLength;
    private final LRUCache<String, Long> lruCache;
    private final long indexForNullNames;
    private final String lookupSql;
    private LookupSQLBuilder lsb;

    public LookupCache(ZipiDatabase zipiDB, String tableName, String nameColumn, int maxLength) {
        this(zipiDB, tableName, "ID", nameColumn, maxLength, -1L, "SELECT (%s) FROM %s WHERE %s=?");
    }

    public LookupCache(ZipiDatabase zipiDB, String tableName, String idColumn, String nameColumn, int maxLength, long indexForNullNames, String lookupSql) {
        this.zipiDB = zipiDB;
        this.tableName = tableName;
        this.idColumn = idColumn;
        this.nameColumn = nameColumn;
        this.maxLength = maxLength;
        this.indexForNullNames = indexForNullNames;
        this.lookupSql = lookupSql;
        this.lruCache = new LRUCache();
    }

    public String getTableName() {
        return this.tableName;
    }

    public String getIdColumn() {
        return this.idColumn;
    }

    public long getIndex(String name) throws SQLException {
        return name != null ? this.getCachedIndex(name) : this.indexForNullNames;
    }

    private long getCachedIndex(String name) throws SQLException {
        Long index = (Long)this.lruCache.get(name = this.trim(name));
        if (index == null) {
            index = this.getAndCacheIndexFromLookupTable(name);
        }
        return index;
    }

    protected String trim(String name) {
        return StringUtils.shorten((String)name, (int)this.maxLength);
    }

    private Long getAndCacheIndexFromLookupTable(String name) throws SQLException {
        this.lsb.setValue(name);
        Long index = this.lookup(this.zipiDB, this.lsb);
        if (index != -1L) {
            this.lruCache.put(name, index);
        }
        return index;
    }

    protected Long lookup(ZipiDatabase zipiDB, LookupSQLBuilder lsb) throws SQLException {
        return zipiDB.getIndexFromLookupTable(lsb);
    }

    public void close() {
        if (this.lsb != null) {
            this.lsb.close();
        }
    }

    public void createLookupSQLBuilder() throws SQLException {
        this.lsb = new LookupSQLBuilder(this.tableName, this.idColumn, this.nameColumn, this.zipiDB, this.lookupSql);
    }

    public LookupBatchPreparedStatement getLookupBatchPreparedStatement() {
        return this.lsb.getLookupBatchPreparedStatement();
    }
}

