/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.pogo.zipi.impl.collector;

import com.cognos.pogo.util.PogoLogger;
import com.ibm.cognos.pogo.zipi.impl.ZipiDatabase;
import com.ibm.cognos.pogo.zipi.impl.collector.LookupBatchPreparedStatement;
import com.ibm.cognos.pogo.zipi.impl.collector.SQLSelectBuilder;
import com.ibm.cognos.pogo.zipi.impl.collector.impl.SQLSelectBuilderImpl;
import java.sql.SQLException;
import org.apache.commons.lang.StringUtils;

public class LookupSQLBuilder {
    public static final String DEFAULT_LOOKUP_SQL = "SELECT (%s) FROM %s WHERE %s=?";
    private static final PogoLogger log = PogoLogger.getLogger();
    private String table;
    private String value;
    private SQLSelectBuilderImpl sb;
    private LookupBatchPreparedStatement lbps;

    protected LookupSQLBuilder() {
    }

    public LookupSQLBuilder(String table, String nameColumn, ZipiDatabase database) throws SQLException {
        this(table, "ID", nameColumn, database);
    }

    public LookupSQLBuilder(String table, String idColumn, String nameColumn, ZipiDatabase database) throws SQLException {
        this(table, idColumn, nameColumn, database, DEFAULT_LOOKUP_SQL);
    }

    public LookupSQLBuilder(String table, String idColumn, String nameColumn, ZipiDatabase database, String lookupSql) throws SQLException {
        this.table = table;
        this.sb = new SQLSelectBuilderImpl(table, idColumn, nameColumn, database, lookupSql);
        this.lbps = new LookupBatchPreparedStatement(table, nameColumn, database);
    }

    public SQLSelectBuilder getSQLSelectBuilder() {
        return this.sb;
    }

    public void addBatch(long nextId) throws SQLException {
        this.lbps.setString(1, this.value);
        this.lbps.setLong(2, nextId);
        this.lbps.addBatch();
    }

    public void flushBatch() throws SQLException {
        this.lbps.flushBatch();
    }

    public void setValue(String value) throws SQLException {
        this.value = value;
        this.sb.setValue(value);
    }

    public String getTable() {
        return this.table;
    }

    public String getValue() {
        return this.value;
    }

    public void closeStatement() {
        this.sb.closeStatement();
    }

    public void close() {
        try {
            this.flushBatch();
        }
        catch (SQLException e) {
            log.info(new Object[]{"Catching flushBatch exception so that the other lookup table gets closed"});
        }
        finally {
            this.closeStatement();
        }
    }

    public LookupBatchPreparedStatement getLookupBatchPreparedStatement() {
        return this.lbps;
    }

    public boolean isValid() {
        return StringUtils.isNotEmpty((String)this.value);
    }
}

