/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.pogo.zipi.impl.collector;

import com.ibm.cognos.pogo.zipi.impl.ZipiDatabase;
import com.ibm.cognos.pogo.zipi.impl.collector.LRUCache;
import com.ibm.cognos.pogo.zipi.impl.collector.PrimaryKeyCache;
import com.ibm.cognos.pogo.zipi.impl.collector.SecondaryKeys;
import java.sql.SQLException;

public class MultiColumnPrimaryKeyCache
extends PrimaryKeyCache {
    private LRUCache<SecondaryKeys, Long> lruCache = new LRUCache();

    public MultiColumnPrimaryKeyCache(ZipiDatabase zipiDB, String tableName) {
        super(zipiDB, tableName);
    }

    public long saveRecord(String ... nameValues) throws SQLException {
        SecondaryKeys secondaryKeys = this.buildSecondaryKeys(nameValues);
        return this.saveRecord(secondaryKeys, nameValues);
    }

    private long saveRecord(SecondaryKeys secondaryKeys, String ... nameValues) throws SQLException {
        Long index = (Long)this.lruCache.get(secondaryKeys);
        if (index == null) {
            index = this.lookupTable(secondaryKeys, nameValues);
        }
        return index;
    }

    @Override
    protected Long lookupTable(SecondaryKeys secondaryKeys, String ... nameValues) throws SQLException {
        Long index = super.lookupTable(secondaryKeys, nameValues);
        if (this.wasFound(index)) {
            this.lruCache.put(secondaryKeys, index);
        }
        return index;
    }

    protected boolean wasFound(Long index) {
        return index != -1L;
    }
}

