/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.pogo.zipi.impl.collector;

import com.cognos.pogo.util.PogoLogger;
import com.ibm.cognos.pogo.zipi.impl.ZipiDatabase;
import com.ibm.cognos.pogo.zipi.impl.collector.LookupBatchPreparedStatement;
import com.ibm.cognos.pogo.zipi.impl.collector.LookupCache;
import com.ibm.cognos.pogo.zipi.impl.collector.MultiColumnLookupSQLBuilder;
import com.ibm.cognos.pogo.zipi.impl.collector.SecondaryKeyCache;
import com.ibm.cognos.pogo.zipi.impl.collector.SecondaryKeys;
import com.ibm.cognos.pogo.zipi.impl.tables.MultiColumnKeyTable;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;

public class PrimaryKeyCache {
    private static final PogoLogger log = PogoLogger.getLogger();
    protected final ZipiDatabase zipiDB;
    protected final String tableName;
    protected final List<SecondaryKeyCache> secondaryKeyCaches = new ArrayList<SecondaryKeyCache>();
    private final List<String> regularColumns = new ArrayList<String>();
    private MultiColumnKeyTable zipiTable;
    protected MultiColumnLookupSQLBuilder lsb;

    public PrimaryKeyCache(ZipiDatabase zipiDB, String tableName) {
        this.zipiDB = zipiDB;
        this.tableName = tableName;
    }

    public String getTableName() {
        return this.tableName;
    }

    public void addSecondaryKey(String columnId, String columnName, int columnSize) {
        this.secondaryKeyCaches.add(new SecondaryKeyCache(this.zipiDB, this.tableName, columnId, columnName, columnSize));
    }

    public void addColumn(String columnName) {
        this.regularColumns.add(columnName);
    }

    public void prepareBatch() throws SQLException {
        this.zipiTable = (MultiColumnKeyTable)this.zipiDB.getZipiTable(this.tableName);
    }

    public void createLookupSQLBuilder() throws SQLException {
        this.lsb = new MultiColumnLookupSQLBuilder(this.zipiDB, this.zipiTable, this.secondaryKeyCaches);
        for (LookupCache lookupCache : this.secondaryKeyCaches) {
            lookupCache.createLookupSQLBuilder();
        }
    }

    protected void logValues(String ... nameValues) {
        if (!log.isDebugEnabled()) {
            return;
        }
        StringBuilder sb = new StringBuilder("Getting index for: ");
        for (String nameValue : nameValues) {
            sb.append(nameValue).append(", ");
        }
        log.debug(new Object[]{sb});
    }

    public void close() {
        for (LookupCache lookupCache : this.secondaryKeyCaches) {
            lookupCache.close();
        }
        if (this.lsb != null) {
            this.lsb.close();
        }
    }

    public LookupBatchPreparedStatement getLookupBatchPreparedStatement() {
        return this.lsb.getLookupBatchPreparedStatement();
    }

    protected Long lookupTable(SecondaryKeys secondaryKeys, String ... nameValues) throws SQLException {
        this.lsb.setValue(secondaryKeys, nameValues);
        return this.zipiDB.getIndexFromLookupTable(this.lsb);
    }

    protected void insertIntoTable(SecondaryKeys secondaryKeys, String ... nameValues) throws SQLException {
        this.lsb.setValue(secondaryKeys, nameValues);
        this.zipiDB.insertIntoLookupTable(this.lsb);
    }

    protected SecondaryKeys buildSecondaryKeys(String ... nameValues) throws SQLException {
        this.logValues(nameValues);
        int i = 0;
        SecondaryKeys secondaryKeys = new SecondaryKeys();
        for (SecondaryKeyCache cache : this.secondaryKeyCaches) {
            secondaryKeys.add(cache.getSecondaryKeyFor(nameValues[i++]));
        }
        return secondaryKeys;
    }
}

