/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.pogo.zipi.impl.collector;

import com.ibm.cognos.pogo.zipi.impl.ZipiDatabase;
import com.ibm.cognos.pogo.zipi.impl.collector.BatchPreparedStatement;
import com.ibm.cognos.pogo.zipi.impl.tables.RecordDetailsTable;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.Calendar;

public class RecordDetailsBatchPreparedStatement
extends BatchPreparedStatement {
    public static final int START_DATE_TIME_INDEX = 8;
    public static final int THRESHOLD_INDEX = 7;
    public static final int END_DATE_INDEX = 6;
    public static final int END_TIME_INDEX = 5;
    public static final int START_DATE_INDEX = 4;
    public static final int START_TIME_INDEX = 3;
    public static final int USER_ID_INDEX = 2;
    public static final int ZIPIID_INDEX = 1;
    public static final String RECORD_DETAILS_PREPARE_STATEMENT = "INSERT INTO " + RecordDetailsTable.TABLE_NAME + " (" + "ZIPIID" + "," + "USERID" + "," + "STARTTIME" + "," + "STARTDATE" + "," + "ENDTIME" + "," + "ENDDATE" + "," + "THRESHOLD" + "," + "STARTDATETIME" + ") VALUES (?,?,?,?,?,?,?,?)";

    public RecordDetailsBatchPreparedStatement(ZipiDatabase zipidb) throws SQLException {
        super(zipidb, RECORD_DETAILS_PREPARE_STATEMENT);
    }

    public void createBatch(String zipiID, Long userID, Long startClockTime, Long elapsedClockTime, int threshold) throws SQLException {
        this.setString(1, zipiID);
        this.setUserID(userID);
        this.setStartClockTime(startClockTime);
        this.setEndClockTime(startClockTime, elapsedClockTime);
        this.setInt(7, threshold);
        this.addBatch();
    }

    private void setUserID(Long userID) throws SQLException {
        if (userID != null) {
            this.setLong(2, userID);
        } else {
            this.setNull(2, -5);
        }
    }

    private void setStartClockTime(Long startClockTime) throws SQLException {
        if (startClockTime != null) {
            this.setDateAndTime(3, 4, startClockTime);
            this.setTimestamp(8, startClockTime);
        }
    }

    private void setEndClockTime(Long startClockTime, Long elapsedClockTime) throws SQLException {
        if (elapsedClockTime != null) {
            this.setDateAndTime(5, 6, startClockTime + elapsedClockTime);
        }
    }

    private void setDateAndTime(int timeColumnIndex, int dateColumnIndex, Long clockTime) throws SQLException {
        Calendar cal = this.getCalendarFor(clockTime);
        this.setInt(timeColumnIndex, this.formatTime(cal));
        this.setInt(dateColumnIndex, this.formatDate(cal));
    }

    private void setTimestamp(int timestampColumnIndex, Long clockTime) throws SQLException {
        this.setTimestamp(timestampColumnIndex, new Timestamp(clockTime));
    }

    private Calendar getCalendarFor(Long clockTime) {
        Calendar cal = Calendar.getInstance();
        cal.setTimeInMillis(clockTime);
        return cal;
    }

    private int formatDate(Calendar cal) {
        String dateId = String.format("%04d%02d%02d", cal.get(1), cal.get(2) + 1, cal.get(5));
        return Integer.parseInt(dateId);
    }

    private int formatTime(Calendar cal) {
        String timeId = String.format("%02d%02d%02d", cal.get(11), cal.get(12), cal.get(13));
        return Integer.parseInt(timeId);
    }
}

