/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.pogo.zipi.impl.collector;

import com.ibm.cognos.pogo.zipi.impl.ZipiDatabase;
import com.ibm.cognos.pogo.zipi.impl.ZipiMBean;
import com.ibm.cognos.pogo.zipi.impl.ZipiStats;
import com.ibm.cognos.pogo.zipi.impl.collector.Activities;
import com.ibm.cognos.pogo.zipi.impl.collector.CollectedMBean;
import com.ibm.cognos.pogo.zipi.impl.collector.LRUCache;
import com.ibm.cognos.pogo.zipi.impl.collector.LookupSQLBuilder;
import com.ibm.cognos.pogo.zipi.impl.collector.RecordDetails;
import com.ibm.cognos.pogo.zipi.impl.collector.Server;
import com.ibm.cognos.pogo.zipi.impl.tables.ServersTable;
import java.sql.SQLException;

public class Servers {
    private final ZipiDatabase zipiDB;
    private RecordDetails recordDetails;
    private final LRUCache<String, Server> cachedServers;
    private final ZipiStats stats;
    private LookupSQLBuilder lsb;
    private Server currentServer;

    public Servers(ZipiDatabase zipiDB, ZipiStats stats, Activities activities) {
        this(zipiDB, stats, activities, new RecordDetails(zipiDB, activities));
    }

    public Servers(ZipiDatabase zipiDB, ZipiStats stats, Activities activities, RecordDetails recordDetails) {
        this.zipiDB = zipiDB;
        this.stats = stats;
        this.recordDetails = recordDetails;
        this.cachedServers = new LRUCache();
    }

    public void execute(CollectedMBean mbean) throws Exception {
        this.currentServer = this.getOrCreateServer(mbean.getServerName(), mbean.getZipiMBean());
        this.currentServer.execute(mbean);
    }

    public void prepareBatch() throws SQLException {
        this.createLookupBuilder();
        this.recordDetails.prepareBatch(this.lsb.getLookupBatchPreparedStatement());
    }

    private void createLookupBuilder() throws SQLException {
        this.lsb = new LookupSQLBuilder(ServersTable.TABLE_NAME, "SERVER", this.zipiDB);
    }

    private Server getOrCreateServer(String serverName, ZipiMBean zipiMBean) throws Exception {
        Server server = (Server)this.cachedServers.get(serverName);
        if (server == null) {
            server = this.createServer(serverName, zipiMBean);
        }
        return server;
    }

    private Server createServer(String serverName, ZipiMBean zipiMBean) throws Exception {
        if (this.lsb != null) {
            this.lsb.setValue(serverName);
        }
        Long index = this.zipiDB.getIndexFromLookupTable(this.lsb);
        Server server = new Server(index, this.recordDetails, serverName, this.stats);
        server.saveTimeOffset(zipiMBean);
        this.cachedServers.put(serverName, server);
        return server;
    }

    public void logStats() {
        for (Server server : this.cachedServers.values()) {
            server.logStats();
        }
    }

    public void flush() throws SQLException {
        if (this.lsb != null) {
            this.lsb.close();
        }
        this.recordDetails.flushEvents();
    }

    public void interruptCollection() {
        if (this.currentServer != null) {
            this.currentServer.interruptCollection();
        }
    }

    public Server getCurrentServer() {
        return this.currentServer;
    }
}

