/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.pogo.zipi.impl.collector;

import com.cognos.pogo.util.PogoLogger;
import com.ibm.cognos.pogo.zipi.impl.ZipiDatabase;
import com.ibm.cognos.pogo.zipi.impl.collector.LRUCache;
import com.ibm.cognos.pogo.zipi.impl.collector.LookupBatchPreparedStatement;
import com.ibm.cognos.pogo.zipi.impl.collector.LookupSQLBuilder;
import com.ibm.cognos.pogo.zipi.impl.collector.User;
import com.ibm.cognos.pogo.zipi.impl.tables.UsersTable;
import java.sql.SQLException;

public class Users {
    private static final PogoLogger log = PogoLogger.getLogger();
    private static final String ANONYMOUS = "anonymous";
    public static final long UNASSIGNED = 0L;
    private static final int LRU_CACHE_SIZE = 1000;
    private final ZipiDatabase zipiDB;
    private final LRUCache<String, Long> passportCache;
    private final LRUCache<String, Long> usernameCache;
    private LookupSQLBuilder lsb;

    public Users(ZipiDatabase zipiDB) {
        this.zipiDB = zipiDB;
        this.passportCache = new LRUCache(1000);
        this.usernameCache = new LRUCache(1000);
    }

    public long lookupOrCreate(User user) throws SQLException {
        if (user.hasUsername() && user.hasPassport()) {
            long userIdForUserName = this.getUserByName(user);
            String passport = user.getPassport();
            Long userId = (Long)this.getPassportCache().get(passport);
            if (userId == null || userId != userIdForUserName) {
                this.getPassportCache().put(passport, userIdForUserName);
            }
            return userIdForUserName;
        }
        if (user.hasPassport()) {
            return this.getUserByPassport(user);
        }
        if (user.hasUsername()) {
            log.error(new Object[]{"Username has no passport"});
        }
        return -1L;
    }

    private long getUserByName(User user) throws SQLException {
        Long id = this.getCachedUserId(user.getUsername());
        return id != null ? id.longValue() : this.getOrCreateUserId(user);
    }

    public Long getCachedUserId(String userName) {
        return (Long)this.getUsernameCache().get(userName);
    }

    public Long getCachedPassportId(String passport) {
        return (Long)this.getPassportCache().get(passport);
    }

    private long getUserByPassport(User user) throws SQLException {
        String passport = user.getPassport();
        Long id = this.getCachedPassportId(passport);
        return id != null ? id.longValue() : this.getUnassigned(passport);
    }

    private long getUnassigned(String passport) {
        this.getPassportCache().put(passport, 0L);
        return 0L;
    }

    public long getOrCreateAnonymousUser(String passport) throws SQLException {
        Long id = this.getCachedUserId(ANONYMOUS);
        return id == null ? this.lookupOrCreateAnonymousUser(passport) : id.longValue();
    }

    private long lookupOrCreateAnonymousUser(String passport) throws SQLException {
        long id = this.lookupUserId(ANONYMOUS);
        if (id == -1L) {
            id = this.createUserId(ANONYMOUS, passport);
        } else {
            this.updateCache(ANONYMOUS, passport, id);
        }
        return id;
    }

    private long getOrCreateUserId(User user) throws SQLException {
        long id = this.lookupUserId(user.getUsername());
        return id == -1L ? this.createUserId(user) : this.updateCache(user, id);
    }

    private long lookupUserId(String userName) throws SQLException {
        this.lsb.setValue(userName);
        return this.zipiDB.lookup(this.lsb);
    }

    private long updateCache(User user, long id) {
        return this.updateCache(user.getUsername(), user.getPassport(), id);
    }

    private long updateCache(String username, String passport, long id) {
        this.getPassportCache().put(passport, id);
        this.getUsernameCache().put(username, id);
        return id;
    }

    private long createUserId(User user) throws SQLException {
        return this.createUserId(user.getUsername(), user.getPassport());
    }

    private long createUserId(String username, String passport) throws SQLException {
        long id = this.zipiDB.insertIntoLookupTable(this.lsb);
        this.updateCache(username, passport, id);
        return id;
    }

    public LRUCache<String, Long> getPassportCache() {
        return this.passportCache;
    }

    public LRUCache<String, Long> getUsernameCache() {
        return this.usernameCache;
    }

    public void close() {
        if (this.lsb != null) {
            this.lsb.close();
        }
    }

    public void createLookupSQLBuilder() throws SQLException {
        this.lsb = new LookupSQLBuilder(UsersTable.TABLE_NAME, "USERNAME", this.zipiDB);
    }

    public LookupBatchPreparedStatement getLookupBatchPreparedStatement() {
        return this.lsb.getLookupBatchPreparedStatement();
    }

    public void clearCache() {
        this.getPassportCache().clear();
        this.getUsernameCache().clear();
    }
}

