/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.pogo.zipi.impl.collector.cleaner;

import com.cognos.pogo.util.PogoLogger;
import com.ibm.cognos.pogo.zipi.ZipiDatabaseConfiguration;
import com.ibm.cognos.pogo.zipi.impl.ConnectionFactory;
import com.ibm.cognos.pogo.zipi.impl.collector.cleaner.CleanerWorker;
import java.sql.Connection;
import java.sql.SQLException;

public class CleanerController
implements Runnable {
    private static final PogoLogger log = PogoLogger.getLogger();
    private static CleanerController instance = null;
    private boolean running = false;
    private boolean isTestingMode = false;
    private ZipiDatabaseConfiguration config;
    private Connection con = null;
    private int dataExpireThreshold;

    private CleanerController(ZipiDatabaseConfiguration config) {
        this.config = config;
    }

    @Override
    public void run() {
        if (!this.setRunning() || this.isTestingMode) {
            log.debug(new Object[]{"Already running, skip"});
            return;
        }
        if (this.con == null) {
            this.connect();
        }
        try {
            CleanerWorker worker = new CleanerWorker(this.con, this.config.getDriver(), this.dataExpireThreshold);
            worker.execute();
        }
        catch (Exception e) {
            String localizedMessage = e.getLocalizedMessage();
            if (localizedMessage != null && localizedMessage.contains("Closed Connection")) {
                this.connect();
            }
            log.error(new Object[]{localizedMessage});
        }
        finally {
            this.setIsRunning(false);
        }
    }

    protected Connection getConnection() {
        return this.con;
    }

    protected void connect() {
        String driver = this.config.getDriver();
        try {
            Class.forName(driver);
        }
        catch (ClassNotFoundException e) {
            log.error(new Object[]{"No JDBC driver found for ", driver});
        }
        ConnectionFactory sqlConnectionFactory = new ConnectionFactory();
        try {
            this.con = sqlConnectionFactory.createSqlConnection(this.config);
        }
        catch (Exception e) {
            log.error("Failed to connect to ZIPI/IPA database 01", (Throwable)e);
        }
    }

    public static CleanerController getInstance(ZipiDatabaseConfiguration config) {
        return CleanerController.getInstance(config, false);
    }

    public static CleanerController getInstance(ZipiDatabaseConfiguration config, boolean isTestingMode) {
        if (instance == null || isTestingMode) {
            instance = new CleanerController(config);
            CleanerController.instance.isTestingMode = isTestingMode;
        }
        return instance;
    }

    public synchronized boolean isRunning() {
        return this.running;
    }

    private synchronized void setIsRunning(boolean status) {
        this.running = status;
    }

    public synchronized boolean setRunning() {
        if (this.running) {
            return false;
        }
        this.running = true;
        return true;
    }

    public boolean isConnnected() {
        return this.con != null;
    }

    public synchronized void setDataExpireThresholdInSeconds(int dataExpireThreshold) {
        this.dataExpireThreshold = dataExpireThreshold;
    }

    public void disconnect() {
        try {
            this.con.close();
        }
        catch (SQLException e) {
            log.debug(new Object[]{"sql exception" + e.getLocalizedMessage()});
        }
        finally {
            this.con = null;
        }
    }
}

