/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.pogo.zipi.impl.collector.cleaner;

import com.cognos.pogo.util.PogoLogger;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;

public class CleanerWorker {
    private static final PogoLogger log = PogoLogger.getLogger();
    private static final HashMap<String, String> RECORDS = new HashMap<String, String>(){
        private static final long serialVersionUID = 10000L;
        {
            this.put("com.microsoft.sqlserver.jdbc.SQLServerDriver", "DELETE FROM IPA_RECORDETAILS WHERE DATEDIFF (SS, STARTDATETIME, GETDATE( )) > ");
            this.put("oracle.jdbc.OracleDriver", "delete from IPA_RECORDETAILS WHERE extract(day from (SYSTIMESTAMP - STARTDATETIME))*24*60*60 + extract(hour from (SYSTIMESTAMP - STARTDATETIME))*60*60 + extract(minute from (SYSTIMESTAMP - STARTDATETIME))*60  + extract(second from (SYSTIMESTAMP - STARTDATETIME)) > ");
            this.put("com.ibm.db2.jcc.DB2Driver", "DELETE FROM IPA_RECORDETAILS WHERE TIMESTAMPDIFF(2, CHAR(CURRENT_TIMESTAMP-STARTDATETIME)) > ");
        }
    };
    private static final String LOGRECORDS = "DELETE FROM IPA_LOGRECORDS where ZIPIID NOT IN (SELECT ZIPIID FROM IPA_RECORDETAILS )";
    private static final String ACTITIVITY_ACTIONS = "DELETE FROM IPA_ACTIVITY_ACTIONS where id not in (select ACTIVITYID from IPA_LOGRECORDS )";
    private static final String CUB_REQ = "DELETE FROM IPA_CUBE_REQ WHERE ZIPIID not in (select ZIPIID from IPA_RECORDETAILS )";
    private static final String REPORT_REQ = "DELETE FROM IPA_REPORT_REQ WHERE ZIPIID NOT IN (SELECT ZIPIID FROM IPA_RECORDETAILS )";
    private static final String SERVERS = "DELETE FROM IPA_SERVERS WHERE ID not in (SELECT SERVERNAMEID FROM IPA_LOGRECORDS)";
    private static final String USERS = "DELETE FROM IPA_USERS WHERE ID NOT IN ( SELECT USERID FROM IPA_RECORDETAILS)";
    private Connection con = null;
    private String driver = null;
    private int dataExpireThreshold = 36000;

    public CleanerWorker(Connection con, String driver, int dataExpireThreshold) {
        this.driver = driver;
        this.con = con;
        this.dataExpireThreshold = dataExpireThreshold;
    }

    public void execute() throws SQLException {
        this.con.setAutoCommit(false);
        this.cleanTables();
        this.con.commit();
    }

    private void cleanTables() throws SQLException {
        if (this.cleanRecordTable()) {
            Statement st = this.con.createStatement();
            List<String> sqls = Arrays.asList(LOGRECORDS, CUB_REQ, REPORT_REQ);
            for (String sql : sqls) {
                st.addBatch(sql);
            }
            int[] rowCount = st.executeBatch();
            this.log(sqls, rowCount);
            st.close();
        }
    }

    private boolean cleanRecordTable() throws SQLException {
        Statement st = this.con.createStatement();
        log.debug(new Object[]{"clean Record table with JDBC driver[", this.driver + "]"});
        String recordDetails = this.getDeleteSQL(this.driver);
        int ret = st.executeUpdate(recordDetails);
        st.close();
        return ret > 0;
    }

    private void log(List<String> sqls, int[] rowCount) {
        for (int i = 0; i < rowCount.length; ++i) {
            if (rowCount[i] <= 0) continue;
            log.debug(new Object[]{"Delete SQL: " + sqls.get(i) + "  deleted count:" + rowCount[i]});
        }
    }

    public String getDeleteSQL(String driver) {
        return RECORDS.get(driver) + String.valueOf(this.dataExpireThreshold);
    }
}

