/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.pogo.zipi.impl.collector.cleaner;

import com.cognos.pogo.util.PogoLogger;
import com.cognos.pogo.util.timer.PogoTimer;
import com.cognos.pogo.util.timer.PogoTimerOwner;
import com.ibm.cognos.pogo.zipi.ZipiConfig;
import com.ibm.cognos.pogo.zipi.ZipiDatabaseConfiguration;
import com.ibm.cognos.pogo.zipi.ZipiFactory;
import com.ibm.cognos.pogo.zipi.impl.TimerFactory;
import com.ibm.cognos.pogo.zipi.impl.ZipiClient;
import com.ibm.cognos.pogo.zipi.impl.ZipiWallTime;
import com.ibm.cognos.pogo.zipi.impl.collector.cleaner.CleanerController;

public class ZipiCollectorCleaner
implements PogoTimerOwner {
    private static final PogoLogger log = PogoLogger.getLogger();
    private PogoTimer collectorCleanerTimer;
    private final ZipiConfig zipiConfig;
    private long currentCollectionCleanIntervalInMillis;
    private TimerFactory timerFactory;

    public ZipiCollectorCleaner() {
        this(new ZipiClient(), ZipiFactory.getConfig(), new TimerFactory());
    }

    ZipiCollectorCleaner(ZipiClient zipiClient, ZipiConfig zipiConfig, TimerFactory timerFactory) {
        this.zipiConfig = zipiConfig;
        this.timerFactory = timerFactory;
    }

    public void start() {
        log.debug(new Object[]{"start cleaner, ", this.zipiConfig});
        this.stop();
        this.startTimer();
    }

    protected long getCollectionCleanIntervalInMillis() {
        return ZipiWallTime.secsToMillis(this.zipiConfig.getCollectionCleanIntervalInSeconds());
    }

    protected void setCollectionCleanIntervalInMillis(int newIntervnal) {
        this.zipiConfig.setCollectionCleanIntervalInSeconds(newIntervnal);
    }

    private void startTimer() {
        log.info(new Object[]{"Starting collectorcleaner"});
        this.currentCollectionCleanIntervalInMillis = this.getCollectionCleanIntervalInMillis();
        this.collectorCleanerTimer = this.timerFactory.createPeriodicTimer(this, this.currentCollectionCleanIntervalInMillis);
    }

    public void stop() {
        log.debug(new Object[]{"stop"});
        if (this.isCollectorCleanerTimerRunning()) {
            this.stopCollectorCleaner();
        }
    }

    protected boolean isCollectorCleanerTimerRunning() {
        return this.collectorCleanerTimer != null;
    }

    private void stopCollectorCleaner() {
        log.info(new Object[]{"Stopping collector"});
        this.stopCollectionCleanerTimer();
    }

    protected void stopCollectionCleanerTimer() {
        this.collectorCleanerTimer.cancel();
        this.collectorCleanerTimer = null;
    }

    public void handleTimeoutEvent(Object parameter) throws Exception {
        log.debug(new Object[]{"Received timer notification to start collection"});
        if (this.zipiConfig.isIPAEnabled()) {
            ZipiDatabaseConfiguration config = this.zipiConfig.getDatabaseConfig();
            CleanerController cleaner = CleanerController.getInstance(config);
            cleaner.setDataExpireThresholdInSeconds(this.zipiConfig.getDataExpireThresholdInSeconds());
            if (!cleaner.isRunning()) {
                Thread runnable = new Thread(cleaner);
                runnable.start();
            } else {
                log.error(new Object[]{"skip cleaning, current clean interval is " + this.zipiConfig.getDataExpireThresholdInSeconds() + " s"});
            }
        }
    }

    public void reconfigure() {
        if (this.isCollectorCleanerTimerRunning() && this.hasChangedConfiguration()) {
            this.restartTimer();
        }
    }

    private boolean hasChangedConfiguration() {
        return this.getCollectionCleanIntervalInMillis() != this.currentCollectionCleanIntervalInMillis;
    }

    protected void restartTimer() {
        log.debug(new Object[]{"Restarting collector cleaner"});
        this.stopCollectorCleaner();
        this.startTimer();
    }

    protected PogoTimer getTimer() {
        return this.collectorCleanerTimer;
    }
}

