/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.pogo.zipi.impl.collector.impl;

import com.cognos.pogo.util.PogoLogger;
import com.ibm.cognos.pogo.zipi.impl.ZipiDatabase;
import com.ibm.cognos.pogo.zipi.impl.collector.SQLSelectBuilder;
import com.ibm.cognos.pogo.zipi.impl.collector.SecondaryKeyCache;
import com.ibm.cognos.pogo.zipi.impl.collector.SecondaryKeys;
import com.ibm.cognos.pogo.zipi.impl.tables.MultiColumnKeyTable;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.List;
import org.apache.commons.lang.StringUtils;

public class MultiColumnSQLSelectBuilderImpl
implements SQLSelectBuilder {
    private static final PogoLogger log = PogoLogger.getLogger();
    private final MultiColumnKeyTable zipiTable;
    private final PreparedStatement ps;

    public MultiColumnSQLSelectBuilderImpl(ZipiDatabase zipiDB, MultiColumnKeyTable zipiTable, List<SecondaryKeyCache> secondaryKeys) throws SQLException {
        this.zipiTable = zipiTable;
        this.ps = this.getPreparedStatement(zipiDB, zipiTable);
    }

    protected PreparedStatement getPreparedStatement(ZipiDatabase zipiDB, MultiColumnKeyTable zipiTable) throws SQLException {
        String selectSql = zipiTable.getSelectSql();
        return StringUtils.isEmpty((String)selectSql) ? null : zipiDB.prepareStatement(selectSql);
    }

    @Override
    public PreparedStatement getPreparedStatement() throws SQLException {
        return this.ps;
    }

    @Override
    public String getValue() {
        return "secondary keys";
    }

    @Override
    public String getString() {
        return this.zipiTable.getSelectSql();
    }

    public void setValue(SecondaryKeys secondaryKeys) throws SQLException {
        this.zipiTable.setSelectValues(this.ps, secondaryKeys);
    }

    public void closeStatement() {
        if (this.ps != null) {
            try {
                this.ps.close();
            }
            catch (SQLException e) {
                log.warn("Following exception occurred while closing Multi-column Select prepared statement: ", (Throwable)e);
            }
        }
    }
}

