/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.pogo.zipi.impl.dbservers;

import com.ibm.cognos.pogo.zipi.impl.dbservers.NullDbServer;

public abstract class DbServer {
    public static final DbServer NULL = new NullDbServer();
    public static final String NOT_NULL = " NOT NULL";
    public static final String NO_OPTION = "";
    private String tableName;
    private boolean hasParameters;
    private String primaryKey;
    private StringBuilder createTableSql;

    public abstract void addIdentityKey(String var1);

    public abstract boolean isCompatibleWithURL(String var1);

    public abstract String getSqlForListingTables();

    public void startCreateTableCommand(Object tableName) {
        this.tableName = tableName.toString();
        this.hasParameters = false;
        this.primaryKey = null;
        this.createTableSql = new StringBuilder("CREATE TABLE ").append(tableName).append(" (");
    }

    public String getTableName() {
        return this.tableName;
    }

    public void addPrimaryKey(String colName, int length) {
        this.addStringColumn(colName, length, NOT_NULL);
        this.setPrimaryKey(colName);
    }

    public void addPrimaryKey(String colName) {
        this.addIntColumn(colName, NOT_NULL);
        this.setPrimaryKey(colName);
    }

    public void addStringPrimaryKey(String colName, int columnSize) {
        this.addStringColumn(colName, columnSize, NOT_NULL);
        this.setPrimaryKey(colName);
    }

    protected void setPrimaryKey(String colName) {
        this.primaryKey = colName;
    }

    public void addStringColumn(String colName, int length) {
        this.addStringColumn(colName, length, NO_OPTION);
    }

    public void addStringColumn(String colName, int length, String option) {
        this.appendCommaIfNeeded();
        this.createTableSql.append(colName).append(' ');
        this.createTableSql.append(this.getStringType()).append('(').append(length).append(')').append(option);
    }

    private void appendCommaIfNeeded() {
        if (!this.hasParameters) {
            this.hasParameters = true;
        } else {
            this.createTableSql.append(", ");
        }
    }

    public void addForeignKey(String colName, Object tableName, String id) {
        this.appendForeignKey(this.createTableSql, colName, tableName, id);
    }

    protected void appendForeignKey(StringBuilder createTableSql, String colName, Object tableName, String id) {
    }

    public void addReferenceColumn(String colName, Object tableName, String id) {
        this.appendCommaIfNeeded();
        this.appendReferenceColumn(this.createTableSql, colName, tableName, id);
    }

    protected void appendReferenceColumn(StringBuilder sqlCommand, String colName, Object tableName, String id) {
        sqlCommand.append(colName).append(" int REFERENCES ").append(tableName).append(" (").append(id).append(')');
    }

    public void addIntColumn(String colName) {
        this.addIntColumn(colName, NO_OPTION);
    }

    public void addIntColumn(String colName, String option) {
        this.addColumn(colName, this.getIntType(), option);
    }

    public void addBigIntColumn(String colName) {
        this.addBigIntColumn(colName, NO_OPTION);
    }

    public void addBigIntColumn(String colName, String option) {
        this.addColumn(colName, this.getBigIntType(), option);
    }

    public void addDateColumn(String colName, String option) {
        this.addColumn(colName, this.getDateType(), option);
    }

    public void addTimestampColumn(String colName, String option) {
        this.addColumn(colName, this.getTimestampType(), option);
    }

    public void addBooleanColumn(String colName) {
        this.addBooleanColumn(colName, NO_OPTION);
    }

    public void addBooleanColumn(String colName, String option) {
        this.addColumn(colName, this.getBooleanType(), option);
    }

    private void addColumn(String colName, Object type, String option) {
        this.appendCommaIfNeeded();
        this.createTableSql.append(colName).append(' ').append(type).append(option);
    }

    public void setConstraint(String ... colNames) {
        this.appendCommaIfNeeded();
        this.createTableSql.append("CONSTRAINT pk_id_step PRIMARY KEY (");
        this.appendKeys(colNames);
        this.createTableSql.append(")");
    }

    private void appendKeys(String ... colNames) {
        for (int i = 0; i < colNames.length; ++i) {
            if (i == 0) {
                this.createTableSql.append(colNames[i]);
                continue;
            }
            this.createTableSql.append(",").append(colNames[i]);
        }
    }

    protected String getIntType() {
        return "int";
    }

    protected String getBigIntType() {
        return "bigint";
    }

    protected String getDateType() {
        return "date";
    }

    protected String getTimestampType() {
        return "timestamp";
    }

    protected String getBooleanType() {
        return "char";
    }

    protected String getStringType() {
        return "varchar";
    }

    public String[] getSqlForCreatingTable() {
        this.appendPrimaryKeyIfNeeded();
        this.createTableSql.append(")");
        return new String[]{this.createTableSql.toString()};
    }

    private void appendPrimaryKeyIfNeeded() {
        if (this.primaryKey == null) {
            return;
        }
        this.appendCommaIfNeeded();
        this.createTableSql.append("PRIMARY KEY (").append(this.primaryKey).append(")");
    }

    public String[] getSqlForDroppingTable(String tableName) {
        return new String[]{"DROP TABLE " + tableName};
    }

    public String[] getSqlForDroppingLookupTable(String tableName) {
        return this.getSqlForDroppingTable(tableName);
    }

    public boolean isActive() {
        return true;
    }
}

