/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.pogo.zipi.impl.dbservers;

import com.ibm.cognos.pogo.zipi.impl.dbservers.DbServer;

public class OracleServer
extends DbServer {
    private boolean hasIdentityKey;

    @Override
    protected String getBigIntType() {
        return "number(19)";
    }

    @Override
    public void addIdentityKey(String colName) {
        this.addIntColumn(colName);
        this.setPrimaryKey(colName);
        this.hasIdentityKey = true;
    }

    @Override
    public void startCreateTableCommand(Object tableName) {
        super.startCreateTableCommand(tableName);
        this.hasIdentityKey = false;
    }

    @Override
    public String[] getSqlForCreatingTable() {
        if (this.hasIdentityKey) {
            return new String[]{super.getSqlForCreatingTable()[0], this.getCreateSequence(), this.getCreateOrReplaceTrigger()};
        }
        return super.getSqlForCreatingTable();
    }

    private String getCreateSequence() {
        return "CREATE SEQUENCE " + this.getTableName() + "_seq";
    }

    private String getCreateOrReplaceTrigger() {
        return "CREATE OR REPLACE TRIGGER " + this.getTableName() + "_trg BEFORE INSERT ON " + this.getTableName() + " FOR EACH ROW BEGIN SELECT " + this.getTableName() + "_seq.nextval INTO :new.id FROM dual; END;";
    }

    @Override
    public String[] getSqlForDroppingLookupTable(String tableName) {
        if (this.hasIdentityKey) {
            return new String[]{"DROP TRIGGER " + tableName + "_trg", "DROP SEQUENCE " + tableName + "_seq", "DROP TABLE " + tableName};
        }
        return super.getSqlForDroppingTable(tableName);
    }

    @Override
    public String getSqlForListingTables() {
        return "select TABLE_NAME from cat";
    }

    @Override
    public boolean isCompatibleWithURL(String url) {
        return url != null && url.contains("jdbc:oracle:");
    }
}

