/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.pogo.zipi.impl.tables;

import com.ibm.cognos.pogo.zipi.impl.ZipiDatabase;
import com.ibm.cognos.pogo.zipi.impl.ZipiWallTime;
import com.ibm.cognos.pogo.zipi.impl.tables.AllTableNames;
import com.ibm.cognos.pogo.zipi.impl.tables.IdTable;
import java.sql.PreparedStatement;
import java.sql.SQLException;

public class BucketsTable
extends IdTable {
    public static String TABLE_NAME = AllTableNames.BUCKETS;
    public static final String COL_BUCKET_ID = "BUCKET_ID";
    public static final String COL_BUCKET_NAME = "BUCKET_NAME";
    public static final int COL_BUCKET_NAME_SIZE = 250;
    public static final String COL_BUCKET_TYPE = "BUCKET_TYPE";
    public static final int COL_BUCKET_TYPE_SIZE = 50;
    public static final String COL_FROM = "FROM_VALUE";
    public static final String COL_TO = "TO_VALUE";
    private static final Bucket[] BUCKETS = new Bucket[]{new Bucket(1, "< 4 secs", "DURATION", Integer.MIN_VALUE, 3), new Bucket(2, "4 to 10 secs", "DURATION", 4, 10), new Bucket(3, "11 to 30 secs", "DURATION", 11, 30), new Bucket(4, "31 to 60 secs", "DURATION", 31, 60), new Bucket(5, ">= 61 secs", "DURATION", 61, Integer.MAX_VALUE)};

    public BucketsTable() {
        super(TABLE_NAME, COL_BUCKET_ID, COL_BUCKET_NAME, 250);
    }

    @Override
    protected void addMoreTableColumns() {
        this.dbServer.addStringColumn(COL_BUCKET_TYPE, 50);
        this.dbServer.addIntColumn(COL_FROM);
        this.dbServer.addIntColumn(COL_TO);
    }

    @Override
    public void populate(ZipiDatabase zipiDatabase, int value) throws SQLException {
        PreparedStatement ps = zipiDatabase.prepareStatement(this.getInsertPreamble() + "(?,?,?,?,?)");
        for (Bucket bucket : BUCKETS) {
            bucket.setValues(ps);
        }
        zipiDatabase.executeBatchSQL(ps);
    }

    public static long getBucketID(long timeInNanos) {
        for (Bucket bucket : BUCKETS) {
            if (!bucket.contains(timeInNanos)) continue;
            return bucket.getID();
        }
        throw new RuntimeException("Bucket not found for " + timeInNanos + " ns");
    }

    private static class Bucket {
        private final int id;
        private final String name;
        private final String type;
        private final int from;
        private final int to;

        public Bucket(int id, String name, String type, int from, int to) {
            this.id = id;
            this.name = name;
            this.type = type;
            this.from = from;
            this.to = to;
        }

        public long getID() {
            return this.id;
        }

        public void setValues(PreparedStatement ps) throws SQLException {
            ps.setInt(1, this.id);
            ps.setString(2, this.name);
            ps.setString(3, this.type);
            ps.setInt(4, Math.max(this.from, 0));
            ps.setInt(5, this.to);
            ps.addBatch();
        }

        public boolean contains(long timeInNanos) {
            long timeInSecs = ZipiWallTime.nanosToSecs(timeInNanos);
            return timeInSecs >= (long)this.from && timeInSecs <= (long)this.to;
        }
    }
}

