/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.pogo.zipi.impl.tables;

import com.ibm.cognos.pogo.zipi.impl.ZipiDatabase;
import com.ibm.cognos.pogo.zipi.impl.tables.AllTableNames;
import com.ibm.cognos.pogo.zipi.impl.tables.ZipiTable;
import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.GregorianCalendar;

public class CogDatesTable
extends ZipiTable {
    public static String TABLE_NAME = AllTableNames.COGDATES;
    public static final String COL_DATES_ID = "ID";
    public static final String COL_DATE = "COGDATE";
    public static final String COL_YEAR = "YEAR";
    public static final String COL_MONTH = "MONTH";
    public static final String COL_DAY = "DAY";
    public static final String COL_ORD_QUARTER = "CALENDARQUARTER";
    public static final String COL_ORD_WEEK = "CALENDARWEEK";
    public static final String COL_ORD_DAY = "CALENDARDAY";
    public static final String COL_DAY_OF_WEEK = "DAYOFTHEWEEK";
    public static final String COL_DAY_CAPTION = "DAYCAPTION";
    public static final String COL_MONTH_CAPTION = "MONTHCAPTION";
    public static final int COL_DAY_CAPTION_LENGTH = 25;
    public static final int COL_MONTH_CAPTION_LENGTH = 25;
    private static final int[] quarters = new int[]{1, 1, 1, 2, 2, 2, 3, 3, 3, 4, 4, 4};
    private static final String[] daysOfWeek = new String[]{"Sunday", "Monday", "Tuesday", "Wednesday", "Thursday", "Friday", "Saturday"};
    private static final String[] months = new String[]{"January", "February", "March", "April", "May", "June", "July", "August", "September", "October", "November", "December"};

    public CogDatesTable() {
        super(TABLE_NAME);
    }

    @Override
    public String[] getCreateTableSql() {
        this.dbServer.startCreateTableCommand(TABLE_NAME);
        this.dbServer.addPrimaryKey(COL_DATES_ID);
        this.dbServer.addDateColumn(COL_DATE, " NOT NULL");
        this.dbServer.addIntColumn(COL_YEAR, " NOT NULL");
        this.dbServer.addIntColumn(COL_MONTH, " NOT NULL");
        this.dbServer.addIntColumn(COL_DAY, " NOT NULL");
        this.dbServer.addIntColumn(COL_ORD_QUARTER, " NOT NULL");
        this.dbServer.addIntColumn(COL_ORD_WEEK, " NOT NULL");
        this.dbServer.addIntColumn(COL_ORD_DAY, " NOT NULL");
        this.dbServer.addIntColumn(COL_DAY_OF_WEEK, " NOT NULL");
        this.dbServer.addStringColumn(COL_DAY_CAPTION, 25, " NOT NULL");
        this.dbServer.addStringColumn(COL_MONTH_CAPTION, 25, " NOT NULL");
        return this.dbServer.getSqlForCreatingTable();
    }

    @Override
    public void populate(ZipiDatabase zipiDatabase, int years) throws SQLException {
        int startYear = 2014;
        int endYear = 2014 + years;
        int year = 2014;
        int month = 0;
        int day = 1;
        GregorianCalendar cal = new GregorianCalendar(year, month, day);
        String insertClause = this.getInsertPreamble();
        PreparedStatement pStatement = zipiDatabase.prepareStatement(insertClause + "(?,?,?,?,?,?,?,?,?,?,?)");
        while (year < endYear) {
            year = cal.get(1);
            month = cal.get(2);
            day = cal.get(5);
            int dayOfWeek = cal.get(7);
            pStatement.setString(1, this.getDateID(year, month, day));
            pStatement.setDate(2, this.getSqlDate(year, month, day));
            pStatement.setInt(3, year);
            pStatement.setInt(4, month + 1);
            pStatement.setInt(5, day);
            pStatement.setInt(6, quarters[month]);
            pStatement.setInt(7, cal.get(3));
            pStatement.setInt(8, cal.get(6));
            pStatement.setInt(9, dayOfWeek);
            pStatement.setString(10, daysOfWeek[dayOfWeek - 1]);
            pStatement.setString(11, months[month]);
            pStatement.addBatch();
            cal.add(6, 1);
        }
        zipiDatabase.executeBatchSQL(pStatement);
    }

    protected String getDateID(int year, int month, int day) {
        return String.format("%04d%02d%02d", year, month + 1, day);
    }

    protected Date getSqlDate(int year, int month, int day) {
        String dateInSqlFormat = String.format("%04d-%02d-%02d", year, month + 1, day);
        return Date.valueOf(dateInSqlFormat);
    }
}

