/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.pogo.zipi.impl.tables;

import com.cognos.pogo.util.PogoLogger;
import com.ibm.cognos.pogo.zipi.impl.ZipiDatabase;
import com.ibm.cognos.pogo.zipi.impl.collector.BatchPreparedStatement;
import com.ibm.cognos.pogo.zipi.impl.collector.LookupBatchPreparedStatement;
import com.ibm.cognos.pogo.zipi.impl.collector.SecondaryKeys;
import com.ibm.cognos.pogo.zipi.impl.tables.IdTable;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicLong;

public abstract class MultiColumnKeyTable
extends IdTable {
    private static final PogoLogger log = PogoLogger.getLogger();
    private final Map<String, AtomicLong> nextIDs = new HashMap<String, AtomicLong>();
    private String selectSql;
    private String insertSql;

    public MultiColumnKeyTable(String tableName, String nameColumn, String selectSql, String insertSql) {
        this(tableName, "ID", nameColumn, 100, selectSql, insertSql);
    }

    public MultiColumnKeyTable(String tableName, String idColumn, String nameColumn, int nameColumnSize, String selectSql, String insertSql) {
        super(tableName, idColumn, nameColumn, nameColumnSize);
        this.selectSql = selectSql;
        this.insertSql = insertSql;
    }

    public String getSelectSql() {
        return this.selectSql;
    }

    public String getInsertSql() {
        return this.insertSql;
    }

    public void setSelectValues(PreparedStatement ps, SecondaryKeys secondaryKeys) throws SQLException {
        log.debug(new Object[]{"Setting parameters for: ", this.getSelectSql()});
    }

    public void setInsertValues(LookupBatchPreparedStatement preparedStatement, long primaryKey, SecondaryKeys secondaryKeys, String ... nameValues) throws SQLException {
        log.debug(new Object[]{"Setting parameters for: ", this.getInsertSql()});
    }

    protected void setPreparedStatementParameter(PreparedStatement ps, int parameterIndex, Long value) throws SQLException {
        log.debug(new Object[]{"SELECT parameter: index=", parameterIndex, ", value=", value});
        ps.setLong(parameterIndex, value);
    }

    protected void setLong(BatchPreparedStatement ps, int parameterIndex, Long value) throws SQLException {
        log.debug(new Object[]{"INSERT parameter: index=", parameterIndex, ", value=", value});
        ps.setLong(parameterIndex, value);
    }

    protected void setString(BatchPreparedStatement ps, int parameterIndex, String value) throws SQLException {
        log.debug(new Object[]{"INSERT parameter: index=", parameterIndex, ", value=", value});
        ps.setString(parameterIndex, value);
    }

    protected void addIdColumn(String idColumn) {
        this.nextIDs.put(idColumn, new AtomicLong(0L));
    }

    @Override
    public long getNextID(String idColumn) {
        return this.getAtomicNextID(idColumn).incrementAndGet();
    }

    protected AtomicLong getAtomicNextID(String idColumn) {
        AtomicLong nextID = this.nextIDs.get(idColumn);
        if (nextID == null) {
            throw new RuntimeException("Invalid ID column: " + idColumn);
        }
        return nextID;
    }

    @Override
    public void readNextID(ZipiDatabase zipiDatabase) throws SQLException {
        super.readNextID(zipiDatabase);
        for (String idColumn : this.nextIDs.keySet()) {
            this.readNextSecondaryKey(zipiDatabase, idColumn);
        }
    }

    protected void readNextSecondaryKey(ZipiDatabase zipiDatabase, String idColumn) throws SQLException {
        long nextID = this.readNextID(zipiDatabase, idColumn);
        log.debug(new Object[]{"Next ", idColumn, " is ", nextID});
        this.getAtomicNextID(idColumn).set(nextID);
    }
}

