/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.pogo.zipi.impl.tables;

import com.cognos.pogo.util.StringUtils;
import com.ibm.cognos.pogo.zipi.impl.ZipiDatabase;
import com.ibm.cognos.pogo.zipi.impl.collector.LookupBatchPreparedStatement;
import com.ibm.cognos.pogo.zipi.impl.collector.SecondaryKey;
import com.ibm.cognos.pogo.zipi.impl.collector.SecondaryKeys;
import com.ibm.cognos.pogo.zipi.impl.collector.ZipiIdPrimaryKeyCache;
import com.ibm.cognos.pogo.zipi.impl.tables.MultiColumnKeyTable;
import java.sql.SQLException;

public abstract class ReqTable
extends MultiColumnKeyTable {
    public static final int COL_NAME_SIZE = 100;
    public static final int COL_FULL_NAME_SIZE = 500;
    protected static final String NO_SELECT_SQL = "";
    private final String fullnameColumn;
    private final int fullnameColumnSize;

    public ReqTable(String tableName, String idColumn, String nameColumn, int nameColumnSize, String fullnameColumn, int fullnameColumnSize, String selectSql, String insertSql) {
        super(tableName, idColumn, nameColumn, nameColumnSize, selectSql, insertSql);
        this.fullnameColumn = fullnameColumn;
        this.fullnameColumnSize = fullnameColumnSize;
    }

    @Override
    protected void addTableIdColumn(String idColumn) {
        this.dbServer.addIntColumn(idColumn, " NOT NULL");
    }

    @Override
    protected void addMoreTableColumns() {
        this.dbServer.addStringColumn(this.fullnameColumn, this.fullnameColumnSize);
        this.dbServer.addStringPrimaryKey("ZIPIID", 100);
    }

    public ZipiIdPrimaryKeyCache createPrimaryKeyCache(ZipiDatabase zipiDB) {
        ZipiIdPrimaryKeyCache keys = new ZipiIdPrimaryKeyCache(zipiDB, this.getTableName());
        keys.addSecondaryKey(this.getIdColumn(), this.getNameColumn(), this.getNameColumnSize());
        return keys;
    }

    @Override
    public void setInsertValues(LookupBatchPreparedStatement ps, long primaryKey, SecondaryKeys secondaryKeys, String ... nameValues) throws SQLException {
        super.setInsertValues(ps, primaryKey, secondaryKeys, nameValues);
        this.setLong(ps, 1, ((SecondaryKey)secondaryKeys.get(0)).getID());
        this.setString(ps, 2, ((SecondaryKey)secondaryKeys.get(0)).getName());
        this.setString(ps, 3, StringUtils.shorten((String)nameValues[1], (int)500));
        this.setString(ps, 4, nameValues[2]);
        this.setAdditionalInsertValues(ps, secondaryKeys, nameValues);
        ps.addBatch();
    }

    protected void setAdditionalInsertValues(LookupBatchPreparedStatement ps, SecondaryKeys secondaryKeys, String[] nameValues) throws SQLException {
    }
}

