/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.pogo.zipi.impl.tables;

import com.ibm.cognos.pogo.zipi.impl.ZipiDatabase;
import com.ibm.cognos.pogo.zipi.impl.dbservers.DbServer;
import java.sql.SQLException;

public abstract class ZipiTable {
    public static final String COL_ID = "ID";
    public static final String COL_ZIPI_ID = "ZIPIID";
    public static final String COL_START_TIME = "STARTTIME";
    public static final String COL_ELAPSED_TIME = "ELAPSEDTIME";
    public static final String COL_SELF_TIME = "SELFTIME";
    public static final String COL_END_TIME = "ENDTIME";
    public static final String NOT_NULL = " NOT NULL";
    public static final int DEFAULT_COLUMN_SIZE = 100;
    public static final int NO_ID = 0;
    protected String tableName;
    protected DbServer dbServer;

    public abstract String[] getCreateTableSql();

    public ZipiTable(String tableName) {
        this.tableName = tableName;
    }

    public void setDbServer(DbServer dbServer) {
        this.dbServer = dbServer;
    }

    public String getTableName() {
        return this.tableName;
    }

    protected static String buildInsertSql(String tableName, String ... columns) {
        StringBuilder sb = new StringBuilder("INSERT INTO ").append(tableName).append(" (");
        ZipiTable.addColumns(sb, columns);
        ZipiTable.addValues(sb, columns);
        sb.append(")");
        return sb.toString();
    }

    private static void addColumns(StringBuilder sb, String ... columns) {
        for (int i = 0; i < columns.length; ++i) {
            if (i == 0) {
                sb.append(columns[i]);
                continue;
            }
            sb.append(",").append(columns[i]);
        }
    }

    private static void addValues(StringBuilder sb, String ... columns) {
        sb.append(") VALUES (");
        for (int i = 0; i < columns.length; ++i) {
            sb.append(i == 0 ? "?" : ",?");
        }
    }

    protected String getInsertPreamble() {
        return "INSERT INTO " + this.tableName + " VALUES ";
    }

    public String[] getDropTableSql() {
        return this.dbServer.getSqlForDroppingTable(this.tableName);
    }

    public void populate(ZipiDatabase zipiDatabase, int value) throws SQLException {
    }

    public long getNextID(String columnId) {
        return 0L;
    }

    public long getNextID() {
        return this.getNextID(COL_ID);
    }

    public void readNextID(ZipiDatabase zipiDatabase) throws SQLException {
    }

    public void reset() {
    }
}

