/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.pogo.zipi.impl.transaction;

import com.cognos.pogo.http.inprocess.LocalServletRequest;
import com.cognos.pogo.http.inprocess.LocalServletResponse;
import com.cognos.pogo.pdk.performance.transaction.PerformanceTransactionAdapter;
import com.cognos.pogo.util.PogoLogger;
import com.ibm.cognos.pogo.zipi.ZipiFactory;
import com.ibm.cognos.pogo.zipi.ZipiTimer;
import com.ibm.cognos.pogo.zipi.impl.ZipiStorage;
import javax.servlet.http.HttpServletRequest;

public class LocalServletTransaction
extends PerformanceTransactionAdapter {
    private static final PogoLogger log = PogoLogger.getLogger();
    private ZipiTimer zipiTimer = ZipiTimer.NULL;

    public LocalServletTransaction(LocalServletRequest localRequest) {
        this.addZipiHeaders(localRequest);
        this.zipiTimer = ZipiFactory.startTimer((HttpServletRequest)localRequest);
    }

    private void addZipiHeaders(LocalServletRequest request) {
        ZipiTimer currentTimer = ZipiFactory.getCurrentTimer();
        if (currentTimer.isActive()) {
            this.setRequestHeaders(request, currentTimer);
        }
    }

    private void setRequestHeaders(LocalServletRequest request, ZipiTimer currentTimer) {
        if (currentTimer.getZipiID().shouldLog()) {
            this.setRequestHeader(request, "zipi.id", currentTimer.getZipiID().toString());
            this.setRequestHeader(request, "zipi.step", currentTimer.incrementAndGetCurrentStep());
            this.setRequestHeader(request, "zipi.src", ZipiStorage.getSrcURI());
            this.setRequestHeader(request, "zipi.src_svc", ZipiStorage.getCurrentService());
        }
    }

    private void setRequestHeader(LocalServletRequest request, String name, String value) {
        log.debug(new Object[]{"setRequestHeader: ", name, "=", value});
        request.setHeader(name, value);
    }

    public void commit(Object additionalData) {
        log.debug(new Object[]{"commit: ", additionalData});
        this.zipiTimer.stop();
        ZipiStorage.setCurrentService(this.zipiTimer.getTargetService());
        this.updateZipiStep((LocalServletResponse)additionalData);
    }

    private void updateZipiStep(LocalServletResponse localResponse) {
        String responseStep = localResponse.getHeader("zipi.step");
        ZipiTimer currentTimer = ZipiFactory.getCurrentTimer();
        log.debug(new Object[]{"updateZipiStep: ", responseStep, " ", currentTimer});
        currentTimer.setCurrentStep(responseStep);
    }
}

