/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.pogo.zipi.impl.wrappers;

import com.ibm.cognos.pogo.zipi.impl.wrappers.StatementListener;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.Statement;

public class StatementWrapper
implements Statement {
    protected final Statement statement;
    protected final StatementListener listener;

    public StatementWrapper(Statement statement, StatementListener listener) {
        this.statement = statement;
        this.listener = listener;
    }

    @Override
    public void closeOnCompletion() throws SQLException {
        try {
            Class[] params = new Class[]{};
            Method meth = this.statement.getClass().getMethod("closeOnCompletion", params);
            meth.invoke((Object)this.statement, new Object[0]);
        }
        catch (NoSuchMethodException exc) {
            throw new SQLException("INTERNAL ERROR:  closeOnCompletion() called when not implemented:  " + exc.toString());
        }
        catch (IllegalAccessException exc) {
            throw new SQLException("INTERNAL ERROR:  " + exc.toString());
        }
        catch (IllegalArgumentException exc) {
            throw new SQLException("INTERNAL ERROR:  " + exc.toString());
        }
        catch (InvocationTargetException exc) {
            throw new SQLException(exc);
        }
    }

    @Override
    public boolean isCloseOnCompletion() throws SQLException {
        try {
            Class[] params = new Class[]{};
            Method meth = this.statement.getClass().getMethod("isCloseOnCompletion", params);
            Boolean result = (Boolean)meth.invoke((Object)this.statement, new Object[0]);
            return result;
        }
        catch (NoSuchMethodException exc) {
            throw new SQLException("INTERNAL ERROR:  isCloseOnCompletion() called when not implemented:  " + exc.toString());
        }
        catch (IllegalAccessException exc) {
            throw new SQLException("INTERNAL ERROR:  " + exc.toString());
        }
        catch (IllegalArgumentException exc) {
            throw new SQLException("INTERNAL ERROR:  " + exc.toString());
        }
        catch (InvocationTargetException exc) {
            throw new SQLException(exc);
        }
    }

    @Override
    public <T> T unwrap(Class<T> iface) throws SQLException {
        return (T)this.statement;
    }

    @Override
    public boolean isWrapperFor(Class<?> iface) throws SQLException {
        return iface == this.statement.getClass();
    }

    @Override
    public void addBatch(String sql) throws SQLException {
        try {
            this.statement.addBatch(sql);
        }
        catch (SQLException e) {
            this.listener.handleException(e);
            throw e;
        }
    }

    @Override
    public void cancel() throws SQLException {
        try {
            this.statement.cancel();
        }
        catch (SQLException e) {
            this.listener.handleException(e);
            throw e;
        }
    }

    @Override
    public void clearBatch() throws SQLException {
        try {
            this.statement.clearBatch();
        }
        catch (SQLException e) {
            this.listener.handleException(e);
            throw e;
        }
    }

    @Override
    public void clearWarnings() throws SQLException {
        try {
            this.statement.clearWarnings();
        }
        catch (SQLException e) {
            this.listener.handleException(e);
            throw e;
        }
    }

    @Override
    public void close() throws SQLException {
        try {
            this.statement.close();
        }
        catch (SQLException e) {
            this.listener.handleException(e);
            throw e;
        }
    }

    @Override
    public boolean execute(String sql) throws SQLException {
        try {
            return this.statement.execute(sql);
        }
        catch (SQLException e) {
            this.listener.handleException(e);
            throw e;
        }
    }

    @Override
    public boolean execute(String sql, int autoGeneratedKeys) throws SQLException {
        try {
            return this.statement.execute(sql, autoGeneratedKeys);
        }
        catch (SQLException e) {
            this.listener.handleException(e);
            throw e;
        }
    }

    @Override
    public boolean execute(String sql, int[] columnIndexes) throws SQLException {
        try {
            return this.statement.execute(sql, columnIndexes);
        }
        catch (SQLException e) {
            this.listener.handleException(e);
            throw e;
        }
    }

    @Override
    public boolean execute(String sql, String[] columnNames) throws SQLException {
        try {
            return this.statement.execute(sql, columnNames);
        }
        catch (SQLException e) {
            this.listener.handleException(e);
            throw e;
        }
    }

    @Override
    public int[] executeBatch() throws SQLException {
        try {
            return this.statement.executeBatch();
        }
        catch (SQLException e) {
            this.listener.handleException(e);
            throw e;
        }
    }

    @Override
    public ResultSet executeQuery(String sql) throws SQLException {
        try {
            return this.statement.executeQuery(sql);
        }
        catch (SQLException e) {
            this.listener.handleException(e);
            throw e;
        }
    }

    @Override
    public int executeUpdate(String sql) throws SQLException {
        try {
            return this.statement.executeUpdate(sql);
        }
        catch (SQLException e) {
            this.listener.handleException(e);
            throw e;
        }
    }

    @Override
    public int executeUpdate(String sql, int autoGeneratedKeys) throws SQLException {
        try {
            return this.statement.executeUpdate(sql, autoGeneratedKeys);
        }
        catch (SQLException e) {
            this.listener.handleException(e);
            throw e;
        }
    }

    @Override
    public int executeUpdate(String sql, int[] columnIndexes) throws SQLException {
        try {
            return this.statement.executeUpdate(sql, columnIndexes);
        }
        catch (SQLException e) {
            this.listener.handleException(e);
            throw e;
        }
    }

    @Override
    public int executeUpdate(String sql, String[] columnNames) throws SQLException {
        try {
            return this.statement.executeUpdate(sql, columnNames);
        }
        catch (SQLException e) {
            this.listener.handleException(e);
            throw e;
        }
    }

    @Override
    public Connection getConnection() throws SQLException {
        try {
            return this.statement.getConnection();
        }
        catch (SQLException e) {
            this.listener.handleException(e);
            throw e;
        }
    }

    @Override
    public int getFetchDirection() throws SQLException {
        try {
            return this.statement.getFetchDirection();
        }
        catch (SQLException e) {
            this.listener.handleException(e);
            throw e;
        }
    }

    @Override
    public int getFetchSize() throws SQLException {
        try {
            return this.statement.getFetchSize();
        }
        catch (SQLException e) {
            this.listener.handleException(e);
            throw e;
        }
    }

    @Override
    public ResultSet getGeneratedKeys() throws SQLException {
        try {
            return this.statement.getGeneratedKeys();
        }
        catch (SQLException e) {
            this.listener.handleException(e);
            throw e;
        }
    }

    @Override
    public int getMaxFieldSize() throws SQLException {
        try {
            return this.statement.getMaxFieldSize();
        }
        catch (SQLException e) {
            this.listener.handleException(e);
            throw e;
        }
    }

    @Override
    public int getMaxRows() throws SQLException {
        try {
            return this.statement.getMaxRows();
        }
        catch (SQLException e) {
            this.listener.handleException(e);
            throw e;
        }
    }

    @Override
    public boolean getMoreResults() throws SQLException {
        try {
            return this.statement.getMoreResults();
        }
        catch (SQLException e) {
            this.listener.handleException(e);
            throw e;
        }
    }

    @Override
    public boolean getMoreResults(int current) throws SQLException {
        try {
            return this.statement.getMoreResults(current);
        }
        catch (SQLException e) {
            this.listener.handleException(e);
            throw e;
        }
    }

    @Override
    public int getQueryTimeout() throws SQLException {
        try {
            return this.statement.getQueryTimeout();
        }
        catch (SQLException e) {
            this.listener.handleException(e);
            throw e;
        }
    }

    @Override
    public ResultSet getResultSet() throws SQLException {
        try {
            return this.statement.getResultSet();
        }
        catch (SQLException e) {
            this.listener.handleException(e);
            throw e;
        }
    }

    @Override
    public int getResultSetConcurrency() throws SQLException {
        try {
            return this.statement.getResultSetConcurrency();
        }
        catch (SQLException e) {
            this.listener.handleException(e);
            throw e;
        }
    }

    @Override
    public int getResultSetHoldability() throws SQLException {
        try {
            return this.statement.getResultSetHoldability();
        }
        catch (SQLException e) {
            this.listener.handleException(e);
            throw e;
        }
    }

    @Override
    public int getResultSetType() throws SQLException {
        try {
            return this.statement.getResultSetType();
        }
        catch (SQLException e) {
            this.listener.handleException(e);
            throw e;
        }
    }

    @Override
    public int getUpdateCount() throws SQLException {
        try {
            return this.statement.getUpdateCount();
        }
        catch (SQLException e) {
            this.listener.handleException(e);
            throw e;
        }
    }

    @Override
    public SQLWarning getWarnings() throws SQLException {
        try {
            return this.statement.getWarnings();
        }
        catch (SQLException e) {
            this.listener.handleException(e);
            throw e;
        }
    }

    @Override
    public void setCursorName(String name) throws SQLException {
        try {
            this.statement.setCursorName(name);
        }
        catch (SQLException e) {
            this.listener.handleException(e);
            throw e;
        }
    }

    @Override
    public void setEscapeProcessing(boolean enable) throws SQLException {
        try {
            this.statement.setEscapeProcessing(enable);
        }
        catch (SQLException e) {
            this.listener.handleException(e);
            throw e;
        }
    }

    @Override
    public void setFetchDirection(int direction) throws SQLException {
        try {
            this.statement.setFetchDirection(direction);
        }
        catch (SQLException e) {
            this.listener.handleException(e);
            throw e;
        }
    }

    @Override
    public void setFetchSize(int rows) throws SQLException {
        try {
            this.statement.setFetchSize(rows);
        }
        catch (SQLException e) {
            this.listener.handleException(e);
            throw e;
        }
    }

    @Override
    public void setMaxFieldSize(int max) throws SQLException {
        try {
            this.statement.setMaxFieldSize(max);
        }
        catch (SQLException e) {
            this.listener.handleException(e);
            throw e;
        }
    }

    @Override
    public void setMaxRows(int max) throws SQLException {
        try {
            this.statement.setMaxRows(max);
        }
        catch (SQLException e) {
            this.listener.handleException(e);
            throw e;
        }
    }

    @Override
    public void setQueryTimeout(int seconds) throws SQLException {
        try {
            this.statement.setQueryTimeout(seconds);
        }
        catch (SQLException e) {
            this.listener.handleException(e);
            throw e;
        }
    }

    @Override
    public boolean isClosed() throws SQLException {
        try {
            return this.statement.isClosed();
        }
        catch (SQLException e) {
            this.listener.handleException(e);
            throw e;
        }
    }

    @Override
    public void setPoolable(boolean poolable) throws SQLException {
        try {
            this.statement.setPoolable(poolable);
        }
        catch (SQLException e) {
            this.listener.handleException(e);
            throw e;
        }
    }

    @Override
    public boolean isPoolable() throws SQLException {
        try {
            return this.statement.isPoolable();
        }
        catch (SQLException e) {
            this.listener.handleException(e);
            throw e;
        }
    }
}

