/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.jdbc.mock;

import java.io.BufferedReader;
import java.io.IOException;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.regex.Pattern;

public class MockInvocationHandler
implements InvocationHandler {
    private static final String FINER_THROW = "FINER: THROW";
    private static final String FINER_RETURN = "FINER: RETURN";
    private static final String NULL = "null";
    private static final String EXCEPTION_SPLITTER = "(SQLstate:|, ErrorCode:|\\))";
    private static final String THROWABLE_OCCURRED = "Throwable occurred: ";
    private static final Pattern JDBC_INTERFACES_FILTER = Pattern.compile("^(java\\.sql\\..+)|(javax\\.sql\\..+)");
    private static final Pattern INT_MATCHER = Pattern.compile("^\\d+$");
    private static final Pattern DOUBLE_MATCHER = Pattern.compile("^\\d+\\.\\d+$");
    private static final Pattern BOOLEAN_MATCHER = Pattern.compile("(true|false)");
    private static final IdentityHashMap<Class<?>, Class<?>[]> interfaceCache = new IdentityHashMap();
    private static final IdentityHashMap<Class<?>, Class<?>> wrapperMap = MockInvocationHandler.initializeWrapperMap();
    private final HashMap<String, String> infoCache;
    public boolean paused = false;
    BufferedReader traceReader;

    public MockInvocationHandler(BufferedReader reader, HashMap<String, String> ic) {
        this.traceReader = reader;
        this.infoCache = ic;
    }

    @Override
    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        String methodName = method.getName();
        if (methodName.equals("setTransactionIsolation") && (Integer)args[0] == 0) {
            this.paused = !this.paused;
            return null;
        }
        String returnValueText = this.infoCache.get(methodName);
        if (returnValueText == null) {
            returnValueText = this.getReturnValueText(methodName);
        }
        return this.convertToObject(method.getReturnType(), returnValueText);
    }

    private String getReturnValueText(String methodName) throws SQLException {
        String text = "";
        if (!this.paused) {
            int state = 0;
            try {
                block6: while ((text = this.traceReader.readLine()) != null) {
                    if (text.endsWith(methodName)) {
                        ++state;
                        continue;
                    }
                    switch (state) {
                        case 2: {
                            if (!text.startsWith(FINER_THROW)) continue block6;
                            this.makeException(text);
                            continue block6;
                        }
                        case 3: {
                            return text.substring(FINER_RETURN.length()).trim();
                        }
                    }
                }
                text = "";
                this.paused = true;
            }
            catch (IOException e) {
                this.paused = true;
            }
        }
        return text;
    }

    private void makeException(String text) throws SQLException {
        String[] parts = text.split(EXCEPTION_SPLITTER);
        String state = parts[1];
        int code = Integer.valueOf(parts[2]);
        try {
            text = this.traceReader.readLine();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        String reason = text.replace(THROWABLE_OCCURRED, "");
        throw new SQLException(reason, state, code);
    }

    public Object convertToObject(Class<?> c, String objectAsText) throws SQLException {
        if (objectAsText.equals(NULL) || c == Void.TYPE) {
            return null;
        }
        if (JDBC_INTERFACES_FILTER.matcher(c.getName()).matches()) {
            MockInvocationHandler handler = new MockInvocationHandler(this.traceReader, this.infoCache);
            return Proxy.newProxyInstance(this.getClass().getClassLoader(), MockInvocationHandler.getInterfaces(c), (InvocationHandler)handler);
        }
        if (c.isPrimitive()) {
            c = wrapperMap.get(c);
        } else if (c == Object.class) {
            c = INT_MATCHER.matcher(objectAsText).matches() ? Integer.class : (DOUBLE_MATCHER.matcher(objectAsText).matches() ? Double.class : (BOOLEAN_MATCHER.matcher(objectAsText).matches() ? Boolean.class : String.class));
        }
        if (c == Integer.class || c == Short.class || c == Double.class) {
            objectAsText = objectAsText.replace(",", "");
        }
        try {
            Constructor<Object> constructor = c.getConstructor(String.class);
            return constructor.newInstance(objectAsText);
        }
        catch (Exception e) {
            try {
                Method m = c.getMethod("valueOf", String.class);
                return m.invoke(null, objectAsText);
            }
            catch (Exception e1) {
                throw new SQLException("Cannot create " + c.getCanonicalName() + " from string " + objectAsText);
            }
        }
    }

    public static Class<?>[] getInterfaces(Class<?> c) {
        Class<?>[] list = interfaceCache.get(c);
        if (list == null) {
            if (c.isInterface()) {
                list = new Class[c.getInterfaces().length + 1];
                list[0] = c;
                int i = 1;
                for (Class<?> k : c.getInterfaces()) {
                    list[i] = k;
                    ++i;
                }
            } else {
                list = c.getInterfaces();
            }
            interfaceCache.put(c, list);
        }
        return list;
    }

    private static final IdentityHashMap<Class<?>, Class<?>> initializeWrapperMap() {
        IdentityHashMap map = new IdentityHashMap();
        map.put(Boolean.TYPE, Boolean.class);
        map.put(Byte.TYPE, Byte.class);
        map.put(Character.TYPE, Character.class);
        map.put(Short.TYPE, Short.class);
        map.put(Integer.TYPE, Integer.class);
        map.put(Long.TYPE, Long.class);
        map.put(Float.TYPE, Float.class);
        map.put(Double.TYPE, Double.class);
        return map;
    }
}

