/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ba.gemini.commons.api;

import com.ibm.ba.gemini.commons.api.HttpContentEntity;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.zip.InflaterInputStream;

public class HttpStreamContentEntity
implements HttpContentEntity {
    private String contentType;
    private String contentEncoding;
    private InputStream inputStream;

    public HttpStreamContentEntity(InputStream inputStream, String contentType, String contentEncoding) {
        if (inputStream == null) {
            throw new NullPointerException("inputStream cannot be null.");
        }
        this.contentType = contentType;
        this.contentEncoding = contentEncoding;
        this.inputStream = inputStream;
    }

    @Override
    public InputStream getContentStream() {
        if (null != this.contentEncoding && "deflate".equals(this.contentEncoding)) {
            return new BufferedInputStream(new InflaterInputStream(this.inputStream));
        }
        return new BufferedInputStream(this.inputStream);
    }

    @Override
    public InputStream getRawContentStream() {
        return this.inputStream;
    }

    @Override
    public String getContentEncoding() {
        return this.contentEncoding;
    }

    @Override
    public long getContentLength() {
        return -1L;
    }

    @Override
    public String getContentType() {
        return this.contentType;
    }

    @Override
    public long getLastModified() {
        return 0L;
    }

    @Override
    public void close() throws IOException {
        this.inputStream.close();
    }
}

