/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ba.gemini.commons.api;

import com.ibm.ba.gemini.commons.api.ContentEntity;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;

public class InputStreamContentEntity
implements ContentEntity {
    private final InputStream inputStream;
    private final long contentLength;
    private final String contentType;
    private final long lastModified;

    public InputStreamContentEntity(InputStream inputStream, long contentLength, String contentType, long lastModified) {
        if (inputStream == null) {
            throw new NullPointerException("inputStream cannot be null.");
        }
        this.inputStream = inputStream;
        this.contentLength = contentLength;
        this.contentType = contentType;
        this.lastModified = lastModified;
    }

    public InputStreamContentEntity(InputStream inputStream, String contentType, long lastModified) {
        this(inputStream, -1L, contentType, lastModified);
    }

    public InputStreamContentEntity(InputStream inputStream, long contentLength, String contentType) {
        this(inputStream, contentLength, contentType, System.currentTimeMillis());
    }

    public InputStreamContentEntity(InputStream inputStream, String contentType) {
        this(inputStream, -1L, contentType, System.currentTimeMillis());
    }

    @Override
    public void close() throws IOException {
        this.inputStream.close();
    }

    @Override
    public InputStream getContentStream() {
        if (this.inputStream instanceof BufferedInputStream) {
            return this.inputStream;
        }
        return new BufferedInputStream(this.inputStream);
    }

    @Override
    public long getContentLength() {
        return this.contentLength;
    }

    @Override
    public String getContentType() {
        return this.contentType;
    }

    @Override
    public long getLastModified() {
        return this.lastModified;
    }
}

